/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.chromeConnector.extension.JbWipVm;
import com.intellij.chromeConnector.extension.RemoteDebugger;
import com.intellij.util.Url;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/debugger/wip/WipVmBootstrap;", "", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "init", "Lorg/jetbrains/concurrency/Promise;", "url", "Lcom/intellij/util/Url;", "ChromeConnector"})
public final class WipVmBootstrap {
    private final WipVm vm;

    @NotNull
    public final Promise<?> init(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.vm.enablePage();
        this.vm.enableNetwork();
        this.vm.enableConsole();
        this.vm.enableWorker();
        if (this.vm instanceof JbWipVm) {
            RemoteDebugger remoteDebugger = ((JbWipVm)this.vm).getRemoteDebugger();
            CharSequence charSequence = url.toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"url.toExternalForm()");
            remoteDebugger.navigate(charSequence);
            return PromiseKt.resolvedPromise();
        }
        WipCommandProcessor wipCommandProcessor = this.vm.getCommandProcessor();
        CharSequence charSequence = url.toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"url.toExternalForm()");
        return wipCommandProcessor.send((Request)PageKt.Navigate(charSequence));
    }

    public WipVmBootstrap(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
    }
}

