/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.chromium.sdk.internal.v8native.protocol.input.CommandResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessor;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.ResultReader;
import org.jetbrains.v8.EventMap;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.V8ProtocolUtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001B!\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J%\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0017\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010 \u001a\u00020\u00072\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/v8/V8CommandProcessor;", "Lorg/jetbrains/rpc/CommandProcessor;", "Lorg/jetbrains/v8/protocol/IncomingMessage;", "Lorg/chromium/sdk/internal/v8native/protocol/input/CommandResponse;", "writer", "Lkotlin/Function1;", "Lio/netty/buffer/ByteBuf;", "", "eventMap", "Lorg/jetbrains/v8/EventMap;", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/v8/EventMap;)V", "lastSuccessResponse", "acceptNonSequence", "", "incoming", "call", "response", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "getSequence", "", "incomingWithSeq", "processIncomingJson", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "readIfHasSequence", "readResult", "RESULT", "readMethodName", "", "successResponse", "(Ljava/lang/String;Lorg/chromium/sdk/internal/v8native/protocol/input/CommandResponse;)Ljava/lang/Object;", "write", "message", "Lorg/jetbrains/jsonProtocol/Request;", "v8-backend"})
public final class V8CommandProcessor
extends CommandProcessor<IncomingMessage, CommandResponse, CommandResponse> {
    private CommandResponse lastSuccessResponse;
    private final Function1<ByteBuf, Boolean> writer;
    private final EventMap eventMap;

    public boolean write(@NotNull Request<?> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        return (Boolean)this.writer.invoke((Object)message.getBuffer());
    }

    public final void processIncomingJson(@NotNull JsonReaderEx reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.getMessageManager().processIncoming((Object)V8ProtocolUtilKt.getPROTOCOL_READER().readIncomingMessage(reader));
    }

    @NotNull
    public final CommandResponse lastSuccessResponse() {
        if (this.lastSuccessResponse == null) {
            throw (Throwable)new IllegalStateException();
        }
        CommandResponse commandResponse = this.lastSuccessResponse;
        if (commandResponse == null) {
            Intrinsics.throwNpe();
        }
        return commandResponse;
    }

    @Nullable
    public CommandResponse readIfHasSequence(@NotNull IncomingMessage incoming) {
        Intrinsics.checkParameterIsNotNull((Object)incoming, (String)"incoming");
        return incoming.requestSeq() == -1 ? (CommandResponse)null : incoming.asResponse();
    }

    public int getSequence(@NotNull CommandResponse incomingWithSeq, @NotNull IncomingMessage incoming) {
        Intrinsics.checkParameterIsNotNull((Object)incomingWithSeq, (String)"incomingWithSeq");
        Intrinsics.checkParameterIsNotNull((Object)incoming, (String)"incoming");
        return incoming.requestSeq();
    }

    public void acceptNonSequence(@NotNull IncomingMessage incoming) {
        Intrinsics.checkParameterIsNotNull((Object)incoming, (String)"incoming");
        if (incoming.event() == null) {
            CommandProcessorKt.getLOG().error(incoming.message());
        } else {
            this.eventMap.handleResponseWithHandler(incoming);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(@NotNull CommandResponse response, @NotNull RequestCallback<CommandResponse> callback) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (response.success()) {
            CommandResponse success;
            this.lastSuccessResponse = success = response;
            try {
                callback.onSuccess((Object)success, (ResultReader)this);
            }
            finally {
                this.lastSuccessResponse = null;
            }
        } else {
            String string = ((IncomingMessage)response.getBase()).message();
            if (string == null) {
                string = "Internal messaging error";
            }
            callback.onError((Throwable)PromiseKt.createError((String)string, (boolean)true));
        }
    }

    @Nullable
    public <RESULT> RESULT readResult(@NotNull String readMethodName, @NotNull CommandResponse successResponse) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)readMethodName, (String)"readMethodName");
        Intrinsics.checkParameterIsNotNull((Object)successResponse, (String)"successResponse");
        JsonReaderEx jsonReaderEx = ((IncomingMessage)successResponse.getBase()).body();
        if (jsonReaderEx != null) {
            JsonReaderEx $receiver$iv = jsonReaderEx;
            JsonReaderEx it = $receiver$iv;
            object = V8ProtocolUtilKt.getPROTOCOL_READER().readResult(readMethodName, it);
        } else {
            object = null;
        }
        return (RESULT)object;
    }

    public V8CommandProcessor(@NotNull Function1<? super ByteBuf, Boolean> writer, @NotNull EventMap eventMap) {
        Intrinsics.checkParameterIsNotNull(writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)eventMap, (String)"eventMap");
        this.writer = writer;
        this.eventMap = eventMap;
    }
}

