/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.jsonProtocol.ResponseResultReader;
import org.jetbrains.rpc.CommandProcessor;
import org.jetbrains.rpc.RequestCallback;
import org.jetbrains.rpc.ResultReader;
import org.jetbrains.wip.WipReaderService;
import org.jetbrains.wip.protocol.CommandResponse;
import org.jetbrains.wip.protocol.Event;
import org.jetbrains.wip.protocol.IncomingMessage;
import org.jetbrains.wip.protocol.ProtocolResponseReader;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\b\u0000\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u001e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cJ\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J%\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0003H\u0017\u00a2\u0006\u0002\u0010(J\u0014\u0010)\u001a\u00020\u00072\n\u0010*\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/wip/WipCommandProcessor;", "Lorg/jetbrains/rpc/CommandProcessor;", "Lorg/jetbrains/wip/protocol/IncomingMessage;", "Lorg/jetbrains/wip/protocol/CommandResponse;", "writer", "Lkotlin/Function1;", "Lorg/jetbrains/jsonProtocol/Request;", "", "(Lkotlin/jvm/functions/Function1;)V", "eventMap", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "getEventMap", "()Lorg/jetbrains/jsonProtocol/EventMap;", "acceptNonSequence", "", "incoming", "call", "response", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "commandErrorReceived", "id", "", "errorMessage", "", "commandResultReceived", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "eventEmitted", "method", "data", "getSequence", "incomingWithSeq", "processIncomingJson", "readIfHasSequence", "readResult", "RESULT", "readMethodName", "successResponse", "(Ljava/lang/String;Lorg/jetbrains/wip/protocol/CommandResponse;)Ljava/lang/Object;", "write", "message", "wip-backend"})
public class WipCommandProcessor
extends CommandProcessor<IncomingMessage, CommandResponse, CommandResponse> {
    @NotNull
    private final EventMap<ProtocolResponseReader> eventMap;
    private final Function1<Request<?>, Boolean> writer;

    @NotNull
    public final EventMap<ProtocolResponseReader> getEventMap() {
        return this.eventMap;
    }

    public boolean write(@NotNull Request<?> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        return (Boolean)this.writer.invoke(message);
    }

    public final void commandResultReceived(int id, @Nullable JsonReaderEx reader) {
        this.getMessageManager().getCallbackAndRemove(id).onSuccess((Object)(reader == null ? null : new CommandResponse(reader){
            final /* synthetic */ JsonReaderEx $reader;

            @Nullable
            public JsonReaderEx result() {
                return this.$reader;
            }

            @Nullable
            public Void error() {
                return null;
            }
            {
                this.$reader = $captured_local_variable$0;
            }
        }), (ResultReader)this);
    }

    public final void commandErrorReceived(int id, @NotNull String errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        this.getMessageManager().getCallbackAndRemove(id).onError(errorMessage);
    }

    public final void eventEmitted(@NotNull String method, @Nullable JsonReaderEx data) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        this.eventMap.handleEvent(method, data);
    }

    public void call(@NotNull CommandResponse response, @NotNull RequestCallback<CommandResponse> callback) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (response.result() != null) {
            callback.onSuccess((Object)response, (ResultReader)this);
        } else {
            String message;
            CommandResponse.ErrorInfo errorInfo = response.error();
            if (errorInfo == null) {
                message = "Internal messaging error";
            } else if (UtilKt.isNullOrEmpty(errorInfo.data())) {
                message = errorInfo.message();
            } else {
                ArrayList<String> messageList = new ArrayList<String>();
                messageList.add(errorInfo.message());
                List<String> list = errorInfo.data();
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                messageList.addAll((Collection)list);
                String string = messageList.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"messageList.toString()");
                message = string;
            }
            callback.onError(message);
        }
    }

    @Nullable
    public CommandResponse readIfHasSequence(@NotNull IncomingMessage incoming) {
        Intrinsics.checkParameterIsNotNull((Object)incoming, (String)"incoming");
        return incoming.id() == -1 ? (CommandResponse)null : incoming.asResponse();
    }

    public int getSequence(@NotNull CommandResponse incomingWithSeq, @NotNull IncomingMessage incoming) {
        Intrinsics.checkParameterIsNotNull((Object)incomingWithSeq, (String)"incomingWithSeq");
        Intrinsics.checkParameterIsNotNull((Object)incoming, (String)"incoming");
        return incoming.id();
    }

    public void acceptNonSequence(@NotNull IncomingMessage incoming) {
        Intrinsics.checkParameterIsNotNull((Object)incoming, (String)"incoming");
        Event event = incoming.asNotification();
        this.eventMap.handleEvent(event.method(), event.params());
    }

    @Nullable
    public <RESULT> RESULT readResult(@NotNull String readMethodName, @NotNull CommandResponse successResponse) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)readMethodName, (String)"readMethodName");
        Intrinsics.checkParameterIsNotNull((Object)successResponse, (String)"successResponse");
        JsonReaderEx jsonReaderEx = successResponse.result();
        if (jsonReaderEx != null) {
            JsonReaderEx $receiver$iv = jsonReaderEx;
            JsonReaderEx it = $receiver$iv;
            object = WipReaderService.get().readResult(readMethodName, it);
        } else {
            object = null;
        }
        return (RESULT)object;
    }

    public final void processIncomingJson(@NotNull JsonReaderEx reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.getMessageManager().processIncoming((Object)WipReaderService.get().readIncomingMessage(reader));
    }

    public WipCommandProcessor(@NotNull Function1<? super Request<?>, Boolean> writer) {
        Intrinsics.checkParameterIsNotNull(writer, (String)"writer");
        this.writer = writer;
        ResponseResultReader responseResultReader = WipReaderService.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)responseResultReader, (String)"WipReaderService.get()");
        this.eventMap = new EventMap(responseResultReader);
    }
}

