/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManagerBase;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.JsonReaders;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.EvaluateHack;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipSuspendContextManager$WhenMappings;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipWorkerCommandProcessor;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.debugger.RestartFrameResult;
import org.jetbrains.wip.protocol.debugger.ResumedEventData;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u0014J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%J\b\u0010&\u001a\u00020 H\u0002J+\u0010'\u001a\u0015\u0012\f\u0012\n (*\u0004\u0018\u00010\u00120\u00120\u0018\u00a2\u0006\u0002\b)2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0002H\u0014J\u0010\u0010+\u001a\u00020 2\b\u0010$\u001a\u0004\u0018\u00010%J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020 0-2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010.\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u00010%H\u0016J\u0014\u00100\u001a\u00020 2\n\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0016J\u0014\u00103\u001a\u00020 2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/wip/WipSuspendContextManager;", "Lorg/jetbrains/debugger/SuspendContextManagerBase;", "Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "evaluateHack", "Lorg/jetbrains/wip/EvaluateHack;", "getEvaluateHack$wip_backend", "()Lorg/jetbrains/wip/EvaluateHack;", "hasOverlay", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isRestartFrameSupported", "", "()Z", "canRestartFrame", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "continueVm", "Lorg/jetbrains/concurrency/Promise;", "stepAction", "Lorg/jetbrains/debugger/StepAction;", "stepCount", "", "currentContextCommandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "doSuspend", "", "pausedEventDataReceived", "it", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "workerId", "", "removeOverlay", "restartFrame", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentContext", "resumedEventDataReceived", "sdkStepToProtocolStep", "Lorg/jetbrains/wip/protocol/WipRequest;", "setOverlayMessage", "message", "updateContext", "newContext", "Lorg/jetbrains/debugger/SuspendContext;", "updateStackTrace", "callFrames", "", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "wip-backend"})
public final class WipSuspendContextManager
extends SuspendContextManagerBase<WipSuspendContext, WipCallFrame> {
    private final AtomicBoolean hasOverlay;
    @NotNull
    private final EvaluateHack evaluateHack;
    private final boolean isRestartFrameSupported = true;
    @NotNull
    private final DebugEventListener debugListener;
    private final WipVm vm;

    @NotNull
    public final EvaluateHack getEvaluateHack$wip_backend() {
        return this.evaluateHack;
    }

    public boolean isRestartFrameSupported() {
        return this.isRestartFrameSupported;
    }

    @NotNull
    protected DebugEventListener getDebugListener() {
        return this.debugListener;
    }

    public final void pausedEventDataReceived(@NotNull PausedEventData it, @Nullable String workerId) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        AsyncPromise callback = this.getSuspendCallback().getAndSet(null);
        WipSuspendContext context = new WipSuspendContext(this.vm, workerId, it, callback != null);
        if (this.getContextRef().get() == null) {
            this.setContext(context);
        }
        AsyncPromise asyncPromise = callback;
        if (asyncPromise != null) {
            asyncPromise.setResult(null);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        this.vm.getDebugListener().suspended((SuspendContext)context);
    }

    public final void resumedEventDataReceived(@Nullable String workerId) {
        if (workerId == null) {
            this.removeOverlay();
        }
        this.dismissContext(workerId);
    }

    @NotNull
    protected Promise<Boolean> restartFrame(@NotNull WipCallFrame callFrame, @NotNull WipSuspendContext currentContext) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)((Object)currentContext), (String)"currentContext");
        WipCommandProcessor wipCommandProcessor = ((WipValueManager)currentContext.getValueManager()).getCommandProcessor();
        String string = callFrame.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return wipCommandProcessor.send((Request)DebuggerKt.RestartFrame(string)).thenAsync(new AsyncFunction<? super T, SUB_RESULT>(this, currentContext){
            final /* synthetic */ WipSuspendContextManager this$0;
            final /* synthetic */ WipSuspendContext $currentContext;

            @NotNull
            public final Promise<Boolean> fun(RestartFrameResult it) {
                Promise promise2;
                if (Intrinsics.areEqual((Object)this.this$0.getContext(), (Object)((Object)this.$currentContext)) ^ true) {
                    promise2 = PromiseKt.resolvedPromise((Object)false);
                } else {
                    Promise promise3;
                    if (JsonReaders.findBooleanField((String)"stack_update_needs_step_in", (JsonReaderEx)it.result().getDeferredReader())) {
                        Promise<?> promise4 = this.this$0.continueVm(StepAction.IN, 1);
                        if (promise4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any>");
                        }
                        promise3 = promise4.then((Function)restartFrame.1.INSTANCE);
                    } else {
                        this.$currentContext.setFrames(it.callFrames(), null);
                        promise3 = PromiseKt.resolvedPromise((Object)false);
                    }
                    promise2 = promise3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"if (JsonReaders.findBool\u2026vedPromise(false)\n      }");
                }
                return promise2;
            }
            {
                this.this$0 = wipSuspendContextManager;
                this.$currentContext = wipSuspendContext;
            }
        });
    }

    public boolean canRestartFrame(@NotNull CallFrame callFrame) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        return this.vm.getScriptManager().getScript(callFrame) != null;
    }

    public final void updateStackTrace(@NotNull List<? extends CallFrameValue> callFrames) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(callFrames, (String)"callFrames");
        WipSuspendContext wipSuspendContext = (WipSuspendContext)((Object)this.getContextRef().get());
        if (wipSuspendContext != null) {
            wipSuspendContext.setFrames(callFrames, null);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @NotNull
    protected Promise<Unit> doSuspend() {
        return this.currentContextCommandProcessor().send((Request)DebuggerKt.Pause());
    }

    public void setOverlayMessage(@Nullable String message) {
        if (!(this.currentContextCommandProcessor() instanceof WipWorkerCommandProcessor) && this.hasOverlay.compareAndSet(false, true)) {
            this.vm.getCommandProcessor().send((Request)PageKt.SetOverlayMessage(message));
        }
    }

    @NotNull
    public Promise<?> continueVm(@NotNull StepAction stepAction, int stepCount) {
        Intrinsics.checkParameterIsNotNull((Object)stepAction, (String)"stepAction");
        ((WipValueManager)((WipSuspendContext)this.getContextOrFail()).getValueManager()).markObsolete();
        this.removeOverlay();
        return this.currentContextCommandProcessor().send((Request)this.sdkStepToProtocolStep(stepAction));
    }

    private final void removeOverlay() {
        if (this.hasOverlay.compareAndSet(true, false)) {
            this.vm.getCommandProcessor().send((Request)PageKt.SetOverlayMessage$default(null, 1, null));
        }
    }

    private final WipRequest<Unit> sdkStepToProtocolStep(StepAction stepAction) {
        WipRequest<Unit> wipRequest;
        switch (WipSuspendContextManager$WhenMappings.$EnumSwitchMapping$0[stepAction.ordinal()]) {
            case 1: {
                wipRequest = DebuggerKt.Resume();
                break;
            }
            case 2: {
                wipRequest = DebuggerKt.StepInto();
                break;
            }
            case 3: {
                wipRequest = DebuggerKt.StepIntoAsync();
                break;
            }
            case 4: {
                wipRequest = DebuggerKt.StepOut();
                break;
            }
            case 5: {
                wipRequest = DebuggerKt.StepOver();
                break;
            }
            default: {
                throw (Throwable)new RuntimeException();
            }
        }
        return wipRequest;
    }

    private final WipCommandProcessor currentContextCommandProcessor() {
        WipCommandProcessor wipCommandProcessor;
        WipSuspendContext currentContext = (WipSuspendContext)((Object)this.getContextRef().get());
        if (currentContext != null) {
            WipCommandProcessor wipCommandProcessor2 = ((WipValueManager)currentContext.getValueManager()).getCommandProcessor();
            wipCommandProcessor = wipCommandProcessor2;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)wipCommandProcessor2), (String)"currentContext.valueManager.commandProcessor");
        } else {
            wipCommandProcessor = this.vm.getCommandProcessor();
        }
        return wipCommandProcessor;
    }

    public void updateContext(@NotNull SuspendContext<?> newContext) {
        Intrinsics.checkParameterIsNotNull(newContext, (String)"newContext");
        if (newContext instanceof WipSuspendContext) {
            this.getContextRef().set(newContext);
        }
    }

    public WipSuspendContextManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.hasOverlay = new AtomicBoolean();
        this.evaluateHack = new EvaluateHack(this.vm);
        this.isRestartFrameSupported = true;
        this.debugListener = this.vm.getDebugListener();
        EventMap<ProtocolResponseReader> eventMap = this.vm.getCommandProcessor().getEventMap();
        eventMap.add((EventType)PausedEventData.TYPE, (Function1)new Function1<PausedEventData, Unit>(){

            public final void invoke(@NotNull PausedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.pausedEventDataReceived(it, null);
            }
        });
        eventMap.add((EventType)ResumedEventData.TYPE, (Function1)new Function1<ResumedEventData, Unit>(){

            public final void invoke(@Nullable ResumedEventData it) {
                this.resumedEventDataReceived(null);
            }
        });
    }
}

