/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.WorkerManagerBase;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipBreakpointManager;
import org.jetbrains.wip.WipBreakpointManagerKt;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipWorker;
import org.jetbrains.wip.WipWorkerManager;
import org.jetbrains.wip.WipWorkerManagerKt$sam$Function$b8a6f445;
import org.jetbrains.wip.protocol.console.ConsoleKt;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.worker.DispatchMessageFromWorkerEventData;
import org.jetbrains.wip.protocol.worker.WorkerCreatedEventData;
import org.jetbrains.wip.protocol.worker.WorkerKt;
import org.jetbrains.wip.protocol.worker.WorkerTerminatedEventData;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0018R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a#\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r0\u000b\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/wip/WipWorkerManager;", "Lorg/jetbrains/debugger/WorkerManagerBase;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "activeWorkers", "", "", "getActiveWorkers", "()Ljava/util/Set;", "workers", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/wip/WipWorker;", "Lorg/jetbrains/annotations/NotNull;", "getWorkers", "()Ljava/util/concurrent/ConcurrentMap;", "messageReceived", "", "data", "Lorg/jetbrains/wip/protocol/worker/DispatchMessageFromWorkerEventData;", "workerCreated", "Lorg/jetbrains/wip/protocol/worker/WorkerCreatedEventData;", "workerTerminated", "Lorg/jetbrains/wip/protocol/worker/WorkerTerminatedEventData;", "wip-backend"})
public final class WipWorkerManager
extends WorkerManagerBase {
    @NotNull
    private final ConcurrentMap<String, WipWorker> workers;
    private final WipVm vm;

    @NotNull
    public final ConcurrentMap<String, WipWorker> getWorkers() {
        return this.workers;
    }

    public final void workerCreated(@NotNull WorkerCreatedEventData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String id = data.workerId();
        if (this.workers.containsKey(id)) {
            return;
        }
        WipWorker worker = new WipWorker(id, this.vm);
        this.workers.put(id, worker);
        this.vm.getCommandProcessor().send((Request)WorkerKt.ConnectToWorker(id)).then(new Function<? super T, ? extends SUB_RESULT>(this, worker){
            final /* synthetic */ WipWorkerManager this$0;
            final /* synthetic */ WipWorker $worker;

            @NotNull
            public final Promise<Unit> fun(Unit it) {
                this.$worker.getCommandProcessor().send((Request)DebuggerKt.Enable()).then((Function)new Function<? super T, ? extends SUB_RESULT>(this){
                    final /* synthetic */ workerCreated.1 this$0;

                    public final void fun(Unit it) {
                        Iterable $receiver$iv = WipWorkerManager.access$getVm$p(this.this$0.this$0).getBreakpointManager().getBreakpoints();
                        for (T element$iv : $receiver$iv) {
                            WipBreakpoint it2;
                            WipBreakpoint breakpoint = it2 = (WipBreakpoint)((Object)element$iv);
                            Promise<Pair<String, List<LocationValue>>> promise2 = WipBreakpointManagerKt.sendSetBreakpointRequest(it2.getTarget(), it2.getLine(), it2.getColumn(), it2.getCondition(), this.this$0.$worker.getCommandProcessor());
                            WipBreakpointManager wipBreakpointManager = WipWorkerManager.access$getVm$p(this.this$0.this$0).getBreakpointManager();
                            WipBreakpoint wipBreakpoint = breakpoint;
                            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)wipBreakpoint), (String)"breakpoint");
                            Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> function1 = wipBreakpointManager.breakpointResolvedHandler(wipBreakpoint);
                            promise2.then((Function)(function1 == null ? null : new WipWorkerManagerKt$sam$Function$b8a6f445(function1)));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return this.$worker.getCommandProcessor().send((Request)ConsoleKt.Enable());
            }
            {
                this.this$0 = wipWorkerManager;
                this.$worker = wipWorker;
            }
        });
    }

    public final void workerTerminated(@NotNull WorkerTerminatedEventData data) {
        Unit unit;
        WipWorker worker;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String id = data.workerId();
        WipWorker wipWorker = worker = (WipWorker)this.workers.remove(id);
        if (wipWorker != null) {
            wipWorker.terminate();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    public final void messageReceived(@NotNull DispatchMessageFromWorkerEventData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String workerId = data.workerId();
        Object object = (WipWorker)this.workers.get(workerId);
        if (object == null || (object = ((WipWorker)object).getCommandProcessor()) == null) {
            return;
        }
        Object processor = object;
        ((WipCommandProcessor)((Object)processor)).processIncomingJson(new JsonReaderEx((CharSequence)data.message()));
    }

    @NotNull
    public Set<String> getActiveWorkers() {
        return this.workers.keySet();
    }

    public WipWorkerManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.workers = ContainerUtil.newConcurrentMap();
    }

    @NotNull
    public static final /* synthetic */ WipVm access$getVm$p(WipWorkerManager $this) {
        return $this.vm;
    }
}

