/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.include;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.include.AbstractCssFileIncludeProvider;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.scss.SCSSFileType;

public class SassScssFileIncludeProvider
extends AbstractCssFileIncludeProvider {
    private static final String SASS_EXT = "sass";
    private static final String SCSS_EXT = "scss";

    @NotNull
    public String getId() {
        if ("SASS/SCSS" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "getId"));
        }
        return "SASS/SCSS";
    }

    public boolean acceptFile(VirtualFile file) {
        return file.getFileType() == SASSFileType.SASS || file.getFileType() == SCSSFileType.SCSS;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)SASSFileType.SASS);
        fileTypeSink.consume((Object)SCSSFileType.SCSS);
    }

    protected void addImports(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String hostFileExt, @NotNull String importUri, @NotNull String importUriExt) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "addImports"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "addImports"));
        }
        if (hostFileExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFileExt", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "addImports"));
        }
        if (importUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUri", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "addImports"));
        }
        if (importUriExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUriExt", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "addImports"));
        }
        if (SASS_EXT.equalsIgnoreCase(importUriExt) || SCSS_EXT.equalsIgnoreCase(importUriExt)) {
            SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri);
        } else if (!SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri + "." + SCSS_EXT)) {
            SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri + "." + SASS_EXT);
        }
    }

    private static boolean tryAddImport(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String importUri) {
        String path;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "tryAddImport"));
        }
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "tryAddImport"));
        }
        if (importUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUri", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "tryAddImport"));
        }
        VirtualFile file = SassScssFileIncludeProvider.resolveImport(hostFile, importUri);
        VirtualFile hostFileDir = hostFile.getParent();
        if (file != null && hostFileDir != null && (path = SassScssFileIncludeProvider.getRelativePath(hostFileDir, file)) != null) {
            result.add(new FileIncludeInfo(path));
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile hostFileDir, @NotNull VirtualFile importedFile) {
        if (hostFileDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFileDir", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "getRelativePath"));
        }
        if (importedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedFile", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "getRelativePath"));
        }
        VirtualFile commonAncestor = VfsUtilCore.getCommonAncestor((VirtualFile)hostFileDir, (VirtualFile)importedFile);
        if (commonAncestor == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        VirtualFile dir = hostFileDir;
        while (!commonAncestor.equals(dir)) {
            buffer.append("../");
            if ((dir = dir.getParent()) != null) continue;
            return null;
        }
        buffer.append(VfsUtilCore.getRelativePath((VirtualFile)importedFile, (VirtualFile)commonAncestor, (char)'/'));
        return buffer.toString();
    }

    @Nullable
    private static VirtualFile resolveImport(@NotNull VirtualFile hostFile, @NotNull String importUri) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "resolveImport"));
        }
        if (importUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importUri", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "resolveImport"));
        }
        String systemIndependentImportUri = FileUtil.toSystemIndependentName((String)importUri);
        VirtualFile importedFile = SassScssFileIncludeProvider.findFile(hostFile, systemIndependentImportUri);
        if (importedFile != null && importedFile.isValid()) {
            return importedFile;
        }
        String partialImportUri = SassScssFileIncludeProvider.createPartialImportUri(systemIndependentImportUri);
        VirtualFile partialImportedFile = SassScssFileIncludeProvider.findFile(hostFile, partialImportUri);
        if (partialImportedFile != null && partialImportedFile.isValid()) {
            return partialImportedFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFile(@NotNull VirtualFile hostFile, @NotNull String systemIndependentImportUri) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "findFile"));
        }
        if (systemIndependentImportUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemIndependentImportUri", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "findFile"));
        }
        if (FileUtil.isAbsolutePlatformIndependent((String)systemIndependentImportUri)) {
            return hostFile.getFileSystem().findFileByPath(systemIndependentImportUri);
        }
        VirtualFile hostFileDir = hostFile.getParent();
        if (hostFileDir == null) {
            return null;
        }
        return hostFileDir.findFileByRelativePath(systemIndependentImportUri);
    }

    private static String createPartialImportUri(@NotNull String systemIndependentImportUri) {
        if (systemIndependentImportUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemIndependentImportUri", "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider", "createPartialImportUri"));
        }
        int pos = systemIndependentImportUri.lastIndexOf(47);
        if (pos == -1) {
            return "_" + systemIndependentImportUri;
        }
        String baseName = systemIndependentImportUri.substring(pos + 1);
        String dirName = systemIndependentImportUri.substring(0, pos);
        return dirName + "/_" + baseName;
    }
}

