/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.inspections;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptorStub;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorProviderImpl;
import com.intellij.psi.css.resolve.CssStyleReferenceStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.psi.SCSSInterpolationImpl;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;
import org.jetbrains.plugins.scss.references.SassScssFunctionReference;

public class SassScssElementDescriptorProvider
extends CssElementDescriptorProviderImpl {
    private final CssValueValidatorImpl SASS_VALUE_VALIDATOR = new CssValueValidatorImpl((CssElementDescriptorProvider)this){

        public boolean isValid(@Nullable PsiElement term, @NotNull CssValueDescriptor valueDescriptor) {
            if (valueDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider$1", "isValid"));
            }
            if (term instanceof CssTermList && ((CssTermList)term).getTerms().length == 1) {
                term = (PsiElement)ArrayUtil.getFirstElement((Object[])((CssTermList)term).getTerms());
            }
            if (valueDescriptor instanceof CssNameValue && term != null && term.getTextLength() == 1 && "&".equals(term.getText())) {
                return true;
            }
            if (term instanceof CssTerm && ((CssTerm)term).getTermType() == CssTermTypes.TOGGLE) {
                return super.isValid(term, valueDescriptor);
            }
            if (term != null && (term instanceof SassScssVariableImpl || term.getFirstChild() instanceof SassScssVariableImpl || term instanceof SCSSInterpolationImpl)) {
                return true;
            }
            boolean result = super.isValid(term, valueDescriptor);
            if (!result && term != null) {
                PsiElement firstChild = term.getFirstChild();
                if (firstChild instanceof CssFunction) {
                    term = firstChild;
                }
                if (term instanceof CssFunction) {
                    return SassScssElementDescriptorProvider.super.findFunctionDescriptors(((CssFunction)term).getName(), term).isEmpty();
                }
            }
            return result;
        }
    };

    @NotNull
    public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(final @NotNull String functionName, @Nullable PsiElement context) {
        Object[] results;
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "findFunctionDescriptors"));
        }
        if (context != null && !DumbService.isDumb((Project)context.getProject()) && (results = SassScssFunctionReference.resolveByName(functionName, context, false)).length > 0) {
            List list = ContainerUtil.map((Object[])results, (Function)new Function<ResolveResult, CssFunctionDescriptor>(){

                public CssFunctionDescriptor fun(ResolveResult result) {
                    return new CssFunctionDescriptorStub(functionName, (CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createAnyValueDescriptor(0, -1, null));
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "findFunctionDescriptors"));
            }
            return list;
        }
        Collection collection = super.findFunctionDescriptors(functionName, context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "findFunctionDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        if (PsiTreeUtil.getParentOfType((PsiElement)context, SassScssPropertyRuleset.class) != null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "getAllPseudoSelectorDescriptors"));
            }
            return list;
        }
        Collection collection = super.getAllPseudoSelectorDescriptors(context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "getAllPseudoSelectorDescriptors"));
        }
        return collection;
    }

    public boolean isMyContext(@Nullable PsiElement context) {
        Language stylesheetLanguage = CssPsiUtil.getStylesheetLanguage((PsiElement)context);
        return SASSLanguage.INSTANCE.is(stylesheetLanguage) || SCSSLanguage.INSTANCE.is(stylesheetLanguage);
    }

    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "getPropertyDescriptor"));
        }
        propertyName = SASSSCSSLangUtil.restoreFullPropertyName(propertyName, context);
        return super.getPropertyDescriptor(propertyName, context);
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "findPropertyDescriptors"));
        }
        Collection collection = super.findPropertyDescriptors(SASSSCSSLangUtil.restoreFullPropertyName(propertyName, context), context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "findPropertyDescriptors"));
        }
        return collection;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "getDeclarationsForSimpleSelector"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean providesClassicCss() {
        return false;
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        SassScssMixinDeclaration mixin;
        CssContextType ruleType = super.getCssContextType(context);
        if (ruleType == CssContextType.NONE && (mixin = (SassScssMixinDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, SassScssMixinDeclaration.class)) != null) {
            return CssContextType.ANY;
        }
        return ruleType;
    }

    @NotNull
    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        CssStyleReferenceStub cssStyleReferenceStub = new CssStyleReferenceStub(element, TextRange.create((int)start, (int)end));
        if (cssStyleReferenceStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "getStyleReference"));
        }
        return cssStyleReferenceStub;
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        CssValueValidatorImpl cssValueValidatorImpl = this.SASS_VALUE_VALIDATOR;
        if (cssValueValidatorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider", "getValueValidator"));
        }
        return cssValueValidatorImpl;
    }
}

