/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.struts2.facet.ui.StrutsVersionDetector;
import com.intellij.util.text.VersionComparatorUtil;
import org.jetbrains.annotations.NotNull;

public class StrutsFileTemplateProvider {
    private final String myVersionName;
    private final boolean my21orNewer;

    public StrutsFileTemplateProvider(Module module) {
        this.myVersionName = StrutsVersionDetector.detectStrutsVersion(module);
        this.my21orNewer = this.isNewerThan("2.1");
    }

    @NotNull
    public FileTemplate determineFileTemplate(Project project) {
        String template = this.isNewerThan("2.3") ? "struts_2_3.xml" : (this.my21orNewer ? (this.isNewerThan("2.1.7") ? "struts_2_1_7.xml" : "struts_2_1.xml") : "struts.xml");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
        FileTemplate fileTemplate = fileTemplateManager.getJ2eeTemplate(template);
        if (fileTemplate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/StrutsFileTemplateProvider", "determineFileTemplate"));
        }
        return fileTemplate;
    }

    public boolean is21orNewer() {
        return this.my21orNewer;
    }

    private boolean isNewerThan(String versionName) {
        return VersionComparatorUtil.compare((String)this.myVersionName, (String)versionName) > 0;
    }
}

