/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.annotators;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.StrutsIcons;
import com.intellij.struts2.annotators.DomElementListCellRenderer;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.validator.ValidatorManager;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import icons.Struts2Icons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ActionAnnotatorBase
extends RelatedItemLineMarkerProvider {
    private static final DomElementListCellRenderer ACTION_RENDERER = new DomElementListCellRenderer<Action>(StrutsBundle.message("annotators.action.no.name", new Object[0])){

        @Override
        @NotNull
        @NonNls
        public String getAdditionalLocation(Action action) {
            String string = action != null ? "[" + action.getNamespace() + "] " : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/annotators/ActionAnnotatorBase$1", "getAdditionalLocation"));
            }
            return string;
        }
    };
    private static final NotNullFunction<PathReference, Collection<? extends PsiElement>> PATH_REFERENCE_CONVERTER = new NotNullFunction<PathReference, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(PathReference pathReference) {
            PsiElement resolve = pathReference.resolve();
            Collection<Object> collection = resolve != null ? Collections.singleton(resolve) : Collections.emptyList();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/annotators/ActionAnnotatorBase$2", "fun"));
            }
            return collection;
        }
    };
    private static final NotNullFunction<PathReference, Collection<? extends GotoRelatedItem>> PATH_REFERENCE_GOTO_RELATED_ITEM_PROVIDER = new NotNullFunction<PathReference, Collection<? extends GotoRelatedItem>>(){

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(final PathReference pathReference) {
            PsiElement resolve = pathReference.resolve();
            Collection<Object> collection = resolve != null ? Collections.singleton(new GotoRelatedItem(resolve){

                public Icon getCustomIcon() {
                    return pathReference.getIcon();
                }

                public String getCustomName() {
                    return pathReference.getPath();
                }
            }) : Collections.emptyList();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/annotators/ActionAnnotatorBase$3", "fun"));
            }
            return collection;
        }
    };

    ActionAnnotatorBase() {
    }

    @Nullable
    protected abstract PsiClass getActionPsiClass(@NotNull PsiElement var1);

    protected void collectNavigationMarkers(@NotNull PsiElement element, Collection<? super RelatedItemLineMarkerInfo> lineMarkerInfos) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/annotators/ActionAnnotatorBase", "collectNavigationMarkers"));
        }
        if (!(element instanceof PsiIdentifier)) {
            return;
        }
        PsiClass clazz = this.getActionPsiClass(element.getParent());
        if (clazz == null || clazz.getNameIdentifier() != element) {
            return;
        }
        if (clazz.isInterface() || clazz.isAnnotationType() || !clazz.hasModifierProperty("public") || clazz.hasModifierProperty("abstract")) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        if (module == null || StrutsFacet.getInstance(module) == null) {
            return;
        }
        StrutsManager strutsManager = StrutsManager.getInstance(element.getProject());
        StrutsModel strutsModel = strutsManager.getCombinedModel(module);
        if (strutsModel == null) {
            return;
        }
        ActionAnnotatorBase.installValidationTargets(element, lineMarkerInfos, clazz);
        List<Action> actions = strutsModel.findActionsByClass(clazz);
        if (actions.isEmpty()) {
            return;
        }
        ActionAnnotatorBase.installActionTargets(element, lineMarkerInfos, actions);
        ActionAnnotatorBase.installActionMethods(lineMarkerInfos, clazz, actions);
    }

    private static void installActionTargets(PsiElement element, Collection<? super RelatedItemLineMarkerInfo> lineMarkerInfos, List<Action> actions) {
        String tooltip = actions.size() == 1 ? StrutsBundle.message("annotators.action.goto.tooltip.single", new Object[0]) : StrutsBundle.message("annotators.action.goto.tooltip", new Object[0]);
        NavigationGutterIconBuilder gutterIconBuilder = NavigationGutterIconBuilder.create((Icon)Struts2Icons.Action, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)NavigationGutterIconBuilder.DOM_GOTO_RELATED_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.LEFT).setPopupTitle(StrutsBundle.message("annotators.action.goto.declaration", new Object[0])).setTargets(actions).setTooltipTitle(tooltip).setCellRenderer((PsiElementListCellRenderer)ACTION_RENDERER);
        lineMarkerInfos.add((RelatedItemLineMarkerInfo)gutterIconBuilder.createLineMarkerInfo(element));
    }

    private static void installActionMethods(Collection<? super RelatedItemLineMarkerInfo> lineMarkerInfos, PsiClass clazz, List<Action> actions) {
        HashMap<PsiMethod, Set> pathReferenceMap = new HashMap<PsiMethod, Set>();
        for (Action action : actions) {
            PsiMethod method = action.searchActionMethod();
            if (method == null || !clazz.equals(method.getContainingClass())) continue;
            HashSet pathReferences = new HashSet();
            List results = action.getResults();
            for (Result result : results) {
                PathReference pathReference = (PathReference)result.getValue();
                ContainerUtil.addIfNotNull(pathReferences, (Object)pathReference);
            }
            Set toStore = (Set)ContainerUtil.getOrCreate(pathReferenceMap, (Object)method, new HashSet());
            toStore.addAll(pathReferences);
            pathReferenceMap.put(method, toStore);
        }
        for (Map.Entry entry : pathReferenceMap.entrySet()) {
            NavigationGutterIconBuilder gutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AllIcons.Hierarchy.Base, PATH_REFERENCE_CONVERTER, PATH_REFERENCE_GOTO_RELATED_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.LEFT).setPopupTitle(StrutsBundle.message("annotators.action.goto.result", new Object[0])).setTargets((Collection)entry.getValue()).setTooltipTitle(StrutsBundle.message("annotators.action.goto.result.tooltip", new Object[0]));
            lineMarkerInfos.add((RelatedItemLineMarkerInfo)gutterIconBuilder.createLineMarkerInfo((PsiElement)entry.getKey()));
        }
    }

    private static void installValidationTargets(PsiElement element, Collection<? super RelatedItemLineMarkerInfo> lineMarkerInfos, PsiClass clazz) {
        List<XmlFile> files = ValidatorManager.getInstance(element.getProject()).findValidationFilesFor(clazz);
        if (files.isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder validatorBuilder = NavigationGutterIconBuilder.create((Icon)StrutsIcons.VALIDATION_CONFIG_FILE).setAlignment(GutterIconRenderer.Alignment.LEFT).setTargets(files).setPopupTitle(StrutsBundle.message("annotators.action.goto.validation", new Object[0])).setTooltipTitle(StrutsBundle.message("annotators.action.goto.validation.tooltip", new Object[0]));
        lineMarkerInfos.add((RelatedItemLineMarkerInfo)validatorBuilder.createLineMarkerInfo(element));
    }
}

