/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.dom.inspection.Struts2ModelInspection;
import com.intellij.struts2.dom.inspection.ValidatorBase;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class Struts2ModelValidator
extends ValidatorBase {
    public Struts2ModelValidator() {
        super(StrutsBundle.message("inspections.struts2.model.validator", new Object[0]), StrutsBundle.message("inspections.struts2.model.validator.progress", new Object[0]));
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        StrutsManager strutsManager = StrutsManager.getInstance(project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        FactoryMap<Module, Boolean> enabledForModule = new FactoryMap<Module, Boolean>(){

            protected Boolean create(Module module) {
                return Struts2ModelValidator.this.isEnabledForModule(module);
            }
        };
        THashSet files = new THashSet();
        for (VirtualFile file : context.getCompileScope().getFiles((FileType)StdFileTypes.XML, false)) {
            StrutsModel model;
            PsiFile psiFile;
            Module module = context.getModuleByFile(file);
            if (module == null || !((Boolean)enabledForModule.get((Object)module)).booleanValue() || !((psiFile = psiManager.findFile(file)) instanceof XmlFile) || (model = strutsManager.getModelByFile((XmlFile)psiFile)) == null) continue;
            for (XmlFile configFile : model.getConfigFiles()) {
                ContainerUtil.addIfNotNull((Object)configFile.getVirtualFile(), (Collection)files);
            }
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded((Collection)files, (CompileContext)context);
        return files;
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new Class[]{Struts2ModelInspection.class};
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/inspection/Struts2ModelValidator", "getInspectionToolClasses"));
        }
        return classArray;
    }
}

