/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.model;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.struts.StrutsRoot;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.InterceptorOrStackBase;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.model.impl.DomModelImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StrutsModelImpl
extends DomModelImpl<StrutsRoot>
implements StrutsModel {
    private static final NotNullFunction<DomFileElement<StrutsRoot>, StrutsRoot> ROOT_ELEMENT_MAPPER = new NotNullFunction<DomFileElement<StrutsRoot>, StrutsRoot>(){

        @NotNull
        public StrutsRoot fun(DomFileElement<StrutsRoot> strutsRootDomFileElement) {
            StrutsRoot strutsRoot = (StrutsRoot)strutsRootDomFileElement.getRootElement();
            if (strutsRoot == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsModelImpl$1", "fun"));
            }
            return strutsRoot;
        }
    };
    private static final Function<StrutsRoot, Collection<? extends StrutsPackage>> STRUTS_PACKAGE_COLLECTOR = new Function<StrutsRoot, Collection<? extends StrutsPackage>>(){

        public Collection<? extends StrutsPackage> fun(StrutsRoot strutsRoot) {
            return strutsRoot.getPackages();
        }
    };

    StrutsModelImpl(@NotNull DomFileElement<StrutsRoot> strutsRootDomFileElement, @NotNull Set<XmlFile> xmlFiles) {
        if (strutsRootDomFileElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strutsRootDomFileElement", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "<init>"));
        }
        if (xmlFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFiles", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "<init>"));
        }
        super(strutsRootDomFileElement, xmlFiles);
    }

    @Override
    @NotNull
    public List<StrutsRoot> getMergedStrutsRoots() {
        List list = ContainerUtil.map((Collection)this.getRoots(), ROOT_ELEMENT_MAPPER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "getMergedStrutsRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<StrutsPackage> getStrutsPackages() {
        List list = ContainerUtil.concat(this.getMergedStrutsRoots(), STRUTS_PACKAGE_COLLECTOR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "getStrutsPackages"));
        }
        return list;
    }

    @Override
    @NotNull
    public Set<InterceptorOrStackBase> getAllInterceptorsAndStacks() {
        HashSet<InterceptorOrStackBase> interceptorOrStackBases = new HashSet<InterceptorOrStackBase>();
        for (StrutsPackage strutsPackage : this.getStrutsPackages()) {
            List interceptorList = strutsPackage.getInterceptorStacks();
            interceptorOrStackBases.addAll(interceptorList);
            List interceptors = strutsPackage.getInterceptors();
            interceptorOrStackBases.addAll(interceptors);
        }
        HashSet<InterceptorOrStackBase> hashSet = interceptorOrStackBases;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "getAllInterceptorsAndStacks"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public List<Action> findActionsByName(final @NotNull @NonNls String name, @Nullable @NonNls String namespace) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "findActionsByName"));
        }
        List list = ContainerUtil.findAll(this.getActionsForNamespace(namespace), (Condition)new Condition<Action>(){

            public boolean value(Action action) {
                return action.matchesPath(name);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "findActionsByName"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Action> findActionsByClass(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "findActionsByClass"));
        }
        List<Action> list = this.findActionsByClassInner(clazz, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "findActionsByClass"));
        }
        return list;
    }

    private List<Action> findActionsByClassInner(PsiClass clazz, boolean skipOnFirst) {
        SmartList actionResultList = new SmartList();
        for (StrutsPackage strutsPackage : this.getStrutsPackages()) {
            for (Action action : strutsPackage.getActions()) {
                PsiClass actionClassValue = action.searchActionClass();
                if (!Comparing.equal((Object)clazz, (Object)actionClassValue)) continue;
                actionResultList.add(action);
                if (!skipOnFirst) continue;
                return actionResultList;
            }
        }
        return actionResultList;
    }

    @Override
    public boolean isActionClass(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/struts2/dom/struts/model/StrutsModelImpl", "isActionClass"));
        }
        return !this.findActionsByClassInner(clazz, true).isEmpty();
    }

    @Override
    public List<Action> getActionsForNamespace(@Nullable @NonNls String namespace) {
        SmartList actionResultList = new SmartList();
        for (StrutsPackage strutsPackage : this.getStrutsPackages()) {
            if (namespace != null && !Comparing.equal((String)namespace, (String)strutsPackage.searchNamespace())) continue;
            actionResultList.addAll(strutsPackage.getActions());
        }
        return actionResultList;
    }

    @Override
    public boolean processActions(Processor<Action> processor) {
        for (StrutsPackage strutsPackage : this.getStrutsPackages()) {
            List actions = strutsPackage.getActions();
            if (ContainerUtil.process((List)actions, processor)) continue;
            return false;
        }
        return true;
    }
}

