/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.model.constant;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.struts2.model.constant.StrutsConstantManager;
import com.intellij.struts2.model.constant.contributor.StrutsCoreConstantContributor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StrutsConstantHelper {
    private static final Function<String, String> DOT_PATH_FUNCTION = new Function<String, String>(){

        public String fun(String s) {
            return "." + s;
        }
    };
    private static final Key<CachedValue<AtomicNotNullLazyValue<List<String>>>> KEY_ACTION_EXTENSIONS = Key.create((String)"STRUTS2_ACTION_EXTENSIONS");

    private StrutsConstantHelper() {
    }

    @NotNull
    public static List<String> getActionExtensions(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/model/constant/StrutsConstantHelper", "getActionExtensions"));
        }
        final PsiFile psiFile = psiElement.getContainingFile().getOriginalFile();
        CachedValue extensions = (CachedValue)psiFile.getUserData(KEY_ACTION_EXTENSIONS);
        if (extensions == null) {
            final Project project = psiElement.getProject();
            extensions = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<AtomicNotNullLazyValue<List<String>>>(){

                public CachedValueProvider.Result<AtomicNotNullLazyValue<List<String>>> compute() {
                    AtomicNotNullLazyValue<List<String>> lazyValue = new AtomicNotNullLazyValue<List<String>>(){

                        @NotNull
                        protected List<String> compute() {
                            List extensions = (List)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<List<String>>(){

                                public List<String> compute() {
                                    return StrutsConstantManager.getInstance(project).getConvertedValue((PsiElement)psiFile, StrutsCoreConstantContributor.ACTION_EXTENSION);
                                }
                            });
                            if (extensions == null) {
                                List<String> list = Collections.emptyList();
                                if (list == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/constant/StrutsConstantHelper$2$1", "compute"));
                                }
                                return list;
                            }
                            List list = ContainerUtil.map((Collection)extensions, (Function)DOT_PATH_FUNCTION);
                            if (list == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/constant/StrutsConstantHelper$2$1", "compute"));
                            }
                            return list;
                        }
                    };
                    return CachedValueProvider.Result.create((Object)lazyValue, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
            }, false);
            psiFile.putUserData(KEY_ACTION_EXTENSIONS, (Object)extensions);
        }
        List list = (List)((AtomicNotNullLazyValue)extensions.getValue()).getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/constant/StrutsConstantHelper", "getActionExtensions"));
        }
        return list;
    }
}

