/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.preview;

import com.intellij.javaee.web.DeployedFileUrlConverter;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.model.constant.StrutsConstantHelper;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Struts2UrlConverter
extends DeployedFileUrlConverter {
    public Collection<String> getTargetPaths(final @NotNull PsiFile sourceFile, @NotNull WebFacet webFacet) {
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/struts2/preview/Struts2UrlConverter", "getTargetPaths"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/struts2/preview/Struts2UrlConverter", "getTargetPaths"));
        }
        StrutsModel combinedModel = StrutsManager.getInstance(sourceFile.getProject()).getCombinedModel(webFacet.getModule());
        if (combinedModel == null) {
            return Collections.emptyList();
        }
        List<String> actionExtensions = StrutsConstantHelper.getActionExtensions((PsiElement)sourceFile);
        if (actionExtensions.isEmpty()) {
            return Collections.emptyList();
        }
        final String actionExtension = actionExtensions.get(0);
        final ArrayList<String> list = new ArrayList<String>();
        combinedModel.processActions(new Processor<Action>(){

            public boolean process(Action action) {
                for (Result result : action.getResults()) {
                    PsiElement psiElement;
                    PathReference pathReference = (PathReference)result.getValue();
                    if (pathReference == null || (psiElement = pathReference.resolve()) == null || !psiElement.equals(sourceFile)) continue;
                    String namespace = action.getNamespace();
                    if (!Comparing.equal((String)namespace, (String)"/")) {
                        namespace = namespace + "/";
                    }
                    list.add(namespace + action.getName().getStringValue() + actionExtension);
                }
                return true;
            }
        });
        return list;
    }
}

