/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference.jsp;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.CreateActionMethodQuickFix;
import com.intellij.struts2.reference.jsp.ActionReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionMethodReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider", "getReferencesByElement"));
        }
        XmlAttributeValue methodAttribute = (XmlAttributeValue)psiElement;
        PsiElement parent = methodAttribute.getParent().getParent();
        if (!(parent instanceof XmlTag)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag tag = (XmlTag)parent;
        XmlAttribute action = tag.getAttribute("action");
        if (action == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttributeValue valueElement = action.getValueElement();
        if (valueElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        for (PsiReference psiReference : valueElement.getReferences()) {
            PsiElement resolve;
            if (!(psiReference instanceof ActionReferenceProvider.ActionReference) || !((resolve = psiReference.resolve()) instanceof XmlTag)) continue;
            PsiReference[] psiReferenceArray = new PsiReference[]{new ActionMethodReference(methodAttribute, (XmlTag)resolve)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static class ActionMethodReference
    extends PsiReferenceBase<XmlAttributeValue>
    implements LocalQuickFixProvider,
    EmptyResolveMessageProvider {
        @Nullable
        private final Action action;
        private final String methodName;

        private ActionMethodReference(@NotNull XmlAttributeValue methodElement, @NotNull XmlTag actionTag) {
            if (methodElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodElement", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider$ActionMethodReference", "<init>"));
            }
            if (actionTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionTag", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider$ActionMethodReference", "<init>"));
            }
            super((PsiElement)methodElement);
            this.methodName = methodElement.getValue();
            this.action = (Action)DomUtil.findDomElement((PsiElement)actionTag, Action.class, (boolean)false);
        }

        public PsiElement resolve() {
            if (this.action == null) {
                return null;
            }
            return (PsiElement)ContainerUtil.find((Iterable)this.action.getActionMethods(), (Condition)new Condition<PsiMethod>(){

                public boolean value(PsiMethod psiMethod) {
                    return Comparing.equal((String)psiMethod.getName(), (String)methodName);
                }
            });
        }

        @NotNull
        public Object[] getVariants() {
            if (this.action == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider$ActionMethodReference", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)this.action.getActionMethods());
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider$ActionMethodReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve action-method '" + this.methodName + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionMethodReferenceProvider$ActionMethodReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }

        public LocalQuickFix[] getQuickFixes() {
            if (this.action == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            PsiClass actionClass = this.action.searchActionClass();
            return new LocalQuickFix[]{new CreateActionMethodQuickFix(actionClass, this.methodName)};
        }
    }
}

