/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.tiles;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.TilesModel;
import com.intellij.struts.dom.tiles.Definition;
import com.intellij.struts2.dom.struts.impl.path.StrutsResultContributor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.StrutsApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TilesResultContributor
extends StrutsResultContributor {
    @NonNls
    private static final String TILES_RESULT_TYPE = "tiles";

    @Override
    protected boolean matchesResultType(@NotNull @NonNls String resultType) {
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/struts2/tiles/TilesResultContributor", "matchesResultType"));
        }
        return Comparing.equal((String)resultType, (String)TILES_RESULT_TYPE);
    }

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> psiReferences, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/tiles/TilesResultContributor", "createReferences"));
        }
        if (psiReferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReferences", "com/intellij/struts2/tiles/TilesResultContributor", "createReferences"));
        }
        String currentPackage = this.getNamespace(psiElement);
        if (currentPackage == null) {
            return false;
        }
        List<TilesModel> allTilesModels = TilesResultContributor.getAllTilesModels(psiElement);
        psiReferences.add((PsiReference)new TilesDefinitionReference((XmlTag)psiElement, allTilesModels));
        return true;
    }

    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement psiElement) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/struts2/tiles/TilesResultContributor", "getPathReference"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/tiles/TilesResultContributor", "getPathReference"));
        }
        return this.createDefaultPathReference(path, psiElement, StrutsApiIcons.Tiles.Tile);
    }

    private static List<TilesModel> getAllTilesModels(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/tiles/TilesResultContributor", "getAllTilesModels"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return Collections.emptyList();
        }
        return StrutsManager.getInstance().getAllTilesModels(module);
    }

    private static class TilesDefinitionReference
    extends PsiReferenceBase<XmlTag>
    implements EmptyResolveMessageProvider {
        private final List<TilesModel> allTilesModels;
        private final String definitionName;
        private static final Function<TilesModel, Collection<? extends Definition>> DEFINITION_COLLECTOR = new Function<TilesModel, Collection<? extends Definition>>(){

            public Collection<? extends Definition> fun(TilesModel tilesModel) {
                return tilesModel.getDefinitions();
            }
        };

        private TilesDefinitionReference(@NotNull XmlTag xmlElement, @NotNull List<TilesModel> allTilesModels) {
            if (xmlElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "com/intellij/struts2/tiles/TilesResultContributor$TilesDefinitionReference", "<init>"));
            }
            if (allTilesModels == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allTilesModels", "com/intellij/struts2/tiles/TilesResultContributor$TilesDefinitionReference", "<init>"));
            }
            super((PsiElement)xmlElement, true);
            this.allTilesModels = allTilesModels;
            this.definitionName = xmlElement.getValue().getTrimmedText();
        }

        public PsiElement resolve() {
            for (TilesModel tilesModel : this.allTilesModels) {
                XmlTag definition = tilesModel.getTileTag(this.definitionName);
                if (definition == null) continue;
                return definition;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            List definitions = ContainerUtil.concat(this.allTilesModels, DEFINITION_COLLECTOR);
            ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>();
            for (Definition definition : definitions) {
                String definitionName = definition.getName().getStringValue();
                XmlElement xmlElement = definition.getXmlElement();
                assert (xmlElement != null);
                PsiFile psiFile = xmlElement.getContainingFile();
                if (psiFile == null || !StringUtil.isNotEmpty((String)definitionName)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((Object)definition, (String)definitionName).withIcon(StrutsApiIcons.Tiles.Tile).withTypeText(psiFile.getName());
                variants.add(builder);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(variants);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/tiles/TilesResultContributor$TilesDefinitionReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve Tiles definition '" + this.getValue() + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/tiles/TilesResultContributor$TilesDefinitionReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

