/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram;

import com.intellij.ProjectTopics;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.AbstractSimpleLocalModel;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelDiagramNodeContentManager;
import com.intellij.spring.contexts.model.diagram.SpringNodeGroupRealizer;
import com.intellij.spring.contexts.model.diagram.beans.FilesetLocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.ModuleLocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDependencyEdge;
import com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDiagramNode;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.SpringProfile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringLocalModelsDataModel
extends DiagramDataModel<LocalModelGraphElementWrapper> {
    private final ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter;
    @NotNull
    private final LocalModelGraphElementWrapper myModel;
    @NotNull
    private final SpringLocalModelDiagramNode myRootNode;
    private final boolean showModuleFilesetNodes;
    private final Collection<SpringLocalModelDiagramNode> myNodes;
    private final Collection<SpringLocalModelDependencyEdge> myEdges;
    private final Map<String, NodesGroup> myNodesGroups;

    public SpringLocalModelsDataModel(@NotNull Project project, @NotNull DiagramProvider<LocalModelGraphElementWrapper> provider, @NotNull LocalModelGraphElementWrapper model, boolean showModuleFilesetNodes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "<init>"));
        }
        super(project, provider);
        this.myNodes = ContainerUtil.newLinkedHashSet();
        this.myEdges = ContainerUtil.newLinkedHashSet();
        this.myNodesGroups = ContainerUtil.newLinkedHashMap();
        this.myModel = model;
        this.myRootNode = new SpringLocalModelDiagramNode(model, provider);
        this.showModuleFilesetNodes = showModuleFilesetNodes;
        DomEventListener domEventListener = new DomEventListener(){

            public void eventOccured(DomEvent event) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }
        };
        DomManager.getDomManager((Project)project).addDomEventListener(domEventListener, (Disposable)this);
        this.myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetConfigurationChanged(SpringFacet facet) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }

            public void facetRemoved(SpringFacet facet) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }

            public void facetAdded(SpringFacet facet) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).registerListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter, (Disposable)this);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                SpringLocalModelsDataModel.this.incModificationCount();
            }
        });
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        messageBusConnection.subscribe(ProjectTopics.MODULES);
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC);
    }

    @NotNull
    public Collection<? extends DiagramNode<LocalModelGraphElementWrapper>> getNodes() {
        Collection<SpringLocalModelDiagramNode> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DiagramEdge<LocalModelGraphElementWrapper>> getEdges() {
        Collection<SpringLocalModelDependencyEdge> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getEdges"));
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<LocalModelGraphElementWrapper> n) {
        String string = ((LocalModelGraphElementWrapper)n.getIdentifyingElement()).getTitle();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getNodeName"));
        }
        return string;
    }

    @Nullable
    public DiagramNode<LocalModelGraphElementWrapper> addElement(LocalModelGraphElementWrapper element) {
        return null;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    protected void updateDataModel() {
        RelatedVisitor visitor = new RelatedVisitor(this.getProject());
        this.myModel.accept(visitor);
    }

    @NotNull
    private SpringLocalModelDiagramNode getDiagramNode(@NotNull LocalModelGraphElementWrapper model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getDiagramNode"));
        }
        if (model.equals(this.myRootNode.getIdentifyingElement())) {
            SpringLocalModelDiagramNode springLocalModelDiagramNode = this.myRootNode;
            if (springLocalModelDiagramNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getDiagramNode"));
            }
            return springLocalModelDiagramNode;
        }
        for (SpringLocalModelDiagramNode node : this.myNodes) {
            if (!model.equals(node.getIdentifyingElement())) continue;
            SpringLocalModelDiagramNode springLocalModelDiagramNode = node;
            if (springLocalModelDiagramNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getDiagramNode"));
            }
            return springLocalModelDiagramNode;
        }
        SpringLocalModelDiagramNode springLocalModelDiagramNode = new SpringLocalModelDiagramNode(model, (DiagramProvider<LocalModelGraphElementWrapper>)this.getProvider());
        if (springLocalModelDiagramNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getDiagramNode"));
        }
        return springLocalModelDiagramNode;
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SpringLocalModelsDataModel springLocalModelsDataModel = this;
        if (springLocalModelsDataModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getModificationTracker"));
        }
        return springLocalModelsDataModel;
    }

    public void dispose() {
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).unregisterListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter);
    }

    @NotNull
    public SpringLocalModelDiagramNode getRootNode() {
        SpringLocalModelDiagramNode springLocalModelDiagramNode = this.myNodes.iterator().next();
        if (springLocalModelDiagramNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getRootNode"));
        }
        return springLocalModelDiagramNode;
    }

    private static boolean isLibraryConfig(LocalModelGraphElementWrapper element) {
        if (element instanceof LocalModelWrapper) {
            LocalModel localModel = (LocalModel)element.getElement();
            Project project = localModel.getConfig().getProject();
            return ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibraryClasses(localModel.getConfig().getContainingFile().getVirtualFile());
        }
        return false;
    }

    private boolean showLibraryConfigs() {
        DiagramState diagramState = new DiagramState(this.getBuilder());
        return diagramState.isCategoryEnabled(SpringLocalModelDiagramNodeContentManager.SHOW_LIBRARY_CONFIGS);
    }

    private boolean showFilesetsAsGroups() {
        DiagramState diagramState = new DiagramState(this.getBuilder());
        return diagramState.isCategoryEnabled(SpringLocalModelDiagramNodeContentManager.SHOW_GROUPS);
    }

    public NodesGroup getGroup(DiagramNode<LocalModelGraphElementWrapper> n) {
        SpringFileSet localModelFileSet;
        LocalModelGraphElementWrapper elementWrapper;
        if (!this.showModuleFilesetNodes && this.showFilesetsAsGroups() && (elementWrapper = (LocalModelGraphElementWrapper)n.getIdentifyingElement()) instanceof LocalModelWrapper && (localModelFileSet = SpringLocalModelsDataModel.getFileSetLocalModelConfiguredIn(((LocalModelWrapper)elementWrapper).getElement())) != null) {
            String fileSetName = localModelFileSet.getName();
            NodesGroup group = this.myNodesGroups.get(fileSetName);
            if (group == null) {
                group = new SpringNodeGroupRealizer(fileSetName);
                this.myNodesGroups.put(fileSetName, group);
            }
            return group;
        }
        return super.getGroup(n);
    }

    public void removeEdge(DiagramEdge<LocalModelGraphElementWrapper> edge) {
        if (edge instanceof SpringLocalModelDependencyEdge) {
            SpringLocalModelDependencyEdge localModelDependencyEdge = (SpringLocalModelDependencyEdge)edge;
            final PsiElement dependencyIdentifyingElement = localModelDependencyEdge.getDependency().getIdentifyingElement();
            if (dependencyIdentifyingElement == null) {
                return;
            }
            List<SpringLocalModelDependencyEdge> edges = this.getEdgesByIdentifyingElement(dependencyIdentifyingElement);
            if (edges.size() > 1) {
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    dependencyIdentifyingElement.delete();
                }
            };
            DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), (Runnable)runnable, (String)"Remove edge", null, (PsiElement[])new PsiElement[]{dependencyIdentifyingElement.getContainingFile()});
        }
    }

    private List<SpringLocalModelDependencyEdge> getEdgesByIdentifyingElement(final @NotNull PsiElement dependencyIdentifyingElement) {
        if (dependencyIdentifyingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyIdentifyingElement", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getEdgesByIdentifyingElement"));
        }
        return ContainerUtil.filter(this.myEdges, (Condition)new Condition<SpringLocalModelDependencyEdge>(){

            public boolean value(SpringLocalModelDependencyEdge edge) {
                return dependencyIdentifyingElement.equals(edge.getDependency().getIdentifyingElement());
            }
        });
    }

    private static SpringFileSet getFileSetLocalModelConfiguredIn(@NotNull LocalModel localModel) {
        SpringFacet facet;
        if (localModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localModel", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel", "getFileSetLocalModelConfiguredIn"));
        }
        Module module = localModel.getModule();
        if (module != null && (facet = SpringFacet.getInstance((Module)module)) != null) {
            Set fileSets = SpringFileSetService.getInstance().getAllSets(facet);
            for (SpringFileSet fileSet : fileSets) {
                if (!fileSet.hasFile(localModel.getConfig().getContainingFile().getVirtualFile())) continue;
                return fileSet;
            }
        }
        return null;
    }

    public class RelatedVisitor {
        private final Project project;
        private final SpringManager springManager;

        private RelatedVisitor(Project project) {
            this.project = project;
            this.springManager = SpringManager.getInstance((Project)project);
        }

        public void visitLocalModel(@NotNull LocalModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel$RelatedVisitor", "visitLocalModel"));
            }
            Module module = model.getModule();
            if (module == null || module.isDisposed()) {
                return;
            }
            Set profiles = model.getActiveProfiles();
            LazyModelDependenciesGraph graph = AbstractSimpleLocalModel.getOrCreateLocalModelDependenciesGraph((Module)module, (Set)(profiles == null ? SpringProfile.DEFAULT.getNames() : profiles));
            SpringLocalModelDiagramNode node = SpringLocalModelsDataModel.this.getDiagramNode(LocalModelWrapper.create(model));
            SpringLocalModelsDataModel.this.myNodes.add(node);
            this.visitRelated(node, graph);
        }

        public void visitModule(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel$RelatedVisitor", "visitModule"));
            }
            if (module.isDisposed()) {
                return;
            }
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null) {
                return;
            }
            SpringLocalModelDiagramNode moduleNode = null;
            if (SpringLocalModelsDataModel.this.showModuleFilesetNodes) {
                moduleNode = SpringLocalModelsDataModel.this.getDiagramNode(ModuleLocalModelWrapper.create(module));
                SpringLocalModelsDataModel.this.myNodes.add(moduleNode);
            }
            for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(springFacet)) {
                SpringLocalModelDiagramNode toNode = null;
                if (SpringLocalModelsDataModel.this.showModuleFilesetNodes) {
                    toNode = SpringLocalModelsDataModel.this.getDiagramNode(FilesetLocalModelWrapper.create(fileSet));
                    SpringLocalModelsDataModel.this.myNodes.add(toNode);
                    moduleNode.addChild(toNode);
                    SpringLocalModelDependencyEdge edge = new SpringLocalModelDependencyEdge((DiagramNode<LocalModelGraphElementWrapper>)moduleNode, (DiagramNode<LocalModelGraphElementWrapper>)toNode, LocalModelDependency.create());
                    SpringLocalModelsDataModel.this.myEdges.add(edge);
                }
                this.visitFileSet(toNode, fileSet);
            }
        }

        public void visitFileSet(@NotNull SpringFileSet fileSet) {
            if (fileSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel$RelatedVisitor", "visitFileSet"));
            }
            SpringLocalModelDiagramNode node = null;
            if (SpringLocalModelsDataModel.this.showModuleFilesetNodes) {
                node = SpringLocalModelsDataModel.this.getDiagramNode(FilesetLocalModelWrapper.create(fileSet));
                SpringLocalModelsDataModel.this.myNodes.add(node);
            }
            this.visitFileSet(node, fileSet);
        }

        private void visitFileSet(@Nullable SpringLocalModelDiagramNode node, @NotNull SpringFileSet fileSet) {
            if (fileSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel$RelatedVisitor", "visitFileSet"));
            }
            Module module = fileSet.getFacet().getModule();
            Set profiles = fileSet.getActiveProfiles();
            LazyModelDependenciesGraph graph = AbstractSimpleLocalModel.getOrCreateLocalModelDependenciesGraph((Module)module, (Set)profiles);
            List files = fileSet.getFiles();
            for (VirtualFilePointer file : files) {
                PsiClass[] psiClasses;
                VirtualFile virtualFile = file.getFile();
                if (virtualFile == null) continue;
                PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
                if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
                    LocalXmlModel model = this.springManager.getLocalSpringModel((XmlFile)psiFile, module);
                    if (model == null) continue;
                    this.createEdgeToLocalModelAndVisitIt(node, graph, LocalModelWrapper.create((LocalModel)model), LocalModelDependency.create());
                    continue;
                }
                if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiFile)) continue;
                PsiJavaFile javaFile = (PsiJavaFile)psiFile;
                for (PsiClass psiClass : psiClasses = javaFile.getClasses()) {
                    LocalAnnotationModel model = this.springManager.getLocalSpringModel(psiClass, module);
                    if (model == null) continue;
                    this.createEdgeToLocalModelAndVisitIt(node, graph, LocalModelWrapper.create((LocalModel)model), LocalModelDependency.create());
                }
            }
        }

        private void visitRelated(@NotNull SpringLocalModelDiagramNode fromNode, @NotNull LazyModelDependenciesGraph graph) {
            if (fromNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromNode", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel$RelatedVisitor", "visitRelated"));
            }
            if (graph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel$RelatedVisitor", "visitRelated"));
            }
            for (Pair to : graph.getOrCreateOutDependencies(((LocalModelWrapper)fromNode.getIdentifyingElement()).getElement())) {
                this.createEdgeToLocalModelAndVisitIt(fromNode, graph, LocalModelWrapper.create((LocalModel)to.first), (LocalModelDependency)to.second);
            }
        }

        private void createEdgeToLocalModelAndVisitIt(@Nullable SpringLocalModelDiagramNode fromNode, @NotNull LazyModelDependenciesGraph graph, LocalModelWrapper toNodeLocalModelWrapper, LocalModelDependency dependency) {
            if (graph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/spring/contexts/model/diagram/SpringLocalModelsDataModel$RelatedVisitor", "createEdgeToLocalModelAndVisitIt"));
            }
            SpringLocalModelDiagramNode toNode = SpringLocalModelsDataModel.this.getDiagramNode(toNodeLocalModelWrapper);
            if (toNode == fromNode) {
                return;
            }
            boolean error = false;
            if (!SpringLocalModelsDataModel.this.myNodes.contains((Object)toNode)) {
                SpringLocalModelsDataModel.this.myNodes.add(toNode);
                if (SpringLocalModelsDataModel.this.showLibraryConfigs() || !SpringLocalModelsDataModel.isLibraryConfig(toNode.getIdentifyingElement())) {
                    this.visitRelated(toNode, graph);
                }
            } else {
                error = true;
            }
            if (fromNode != null) {
                SpringLocalModelDependencyEdge edge = new SpringLocalModelDependencyEdge((DiagramNode<LocalModelGraphElementWrapper>)fromNode, (DiagramNode<LocalModelGraphElementWrapper>)toNode, dependency);
                if (error) {
                    edge.setError(true);
                } else {
                    fromNode.addChild(toNode);
                }
                SpringLocalModelsDataModel.this.myEdges.add(edge);
            }
        }
    }
}

