/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.editor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.dom.SpringDomUtils;
import icons.SpringApiIcons;
import javax.swing.Icon;

enum AddFileType {
    PROPERTIES(SpringBundle.message("facet.context.properties.files", new Object[0]), StdFileTypes.PROPERTIES.getIcon()),
    SPRING_XML(SpringBundle.message("facet.context.xml.files", new Object[0]), SpringApiIcons.SpringConfig),
    CODE(SpringBundle.message("facet.context.code.files", new Object[0]), SpringApiIcons.SpringJavaConfig),
    OTHER(SpringBundle.message("facet.context.other.files", new Object[0]), AllIcons.FileTypes.Any_type);

    private final String displayName;
    private final Icon icon;

    private AddFileType(String displayName, Icon icon) {
        this.displayName = displayName;
        this.icon = icon;
    }

    String getDisplayName() {
        return this.displayName;
    }

    Icon getIcon() {
        return this.icon;
    }

    Condition<VirtualFile> getFileVisibleCondition(Project project) {
        if (this == PROPERTIES) {
            return new Condition<VirtualFile>(){

                public boolean value(VirtualFile file) {
                    return file.getFileType() == StdFileTypes.PROPERTIES;
                }
            };
        }
        if (this == CODE) {
            final PsiManager psiManager = PsiManager.getInstance((Project)project);
            return new Condition<VirtualFile>(){

                public boolean value(VirtualFile file) {
                    PsiFile psiFile = psiManager.findFile(file);
                    return psiFile instanceof PsiClassOwner;
                }
            };
        }
        if (this == SPRING_XML) {
            final PsiManager psiManager = PsiManager.getInstance((Project)project);
            return new Condition<VirtualFile>(){

                public boolean value(VirtualFile file) {
                    if (file.getFileType() != StdFileTypes.XML) {
                        return false;
                    }
                    PsiFile psiFile = psiManager.findFile(file);
                    return psiFile instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile));
                }
            };
        }
        return Conditions.alwaysTrue();
    }
}

