/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.openapi.util.Pair;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.validation.SpringFileSetGraph;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import java.util.Set;

class SpringFileSetCycleChecker {
    private final DFSTBuilder<SpringFileSet> myDFSTBuilder;

    SpringFileSetCycleChecker(Set<SpringFileSet> fileSets) {
        CachingSemiGraph graph = CachingSemiGraph.create((GraphGenerator.SemiGraph)new SpringFileSetGraph(fileSets));
        this.myDFSTBuilder = new DFSTBuilder((Graph)GraphGenerator.create((GraphGenerator.SemiGraph)graph));
    }

    boolean hasCycles() {
        return !this.myDFSTBuilder.isAcyclic();
    }

    Pair<SpringFileSet, SpringFileSet> getCircularDependency() {
        return this.myDFSTBuilder.getCircularDependency();
    }
}

