/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.model.highlighting.config.SpringFacetProgrammaticInspection;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SpringProgrammaticConfigurationCollector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.facet.validation.SpringProgrammaticConfigurationCollector");
    private static final String CONTEXT_BASE_CLASS = "org.springframework.context.support.ClassPathXmlApplicationContext";
    private static final LocalInspectionTool PROGRAMMATIC_CONFIG_INSPECTION = new SpringFacetProgrammaticInspection();
    private final Project myProject;
    private final InspectionProfile myProfile;
    private final DetectionExcludesConfiguration myDetectionExcludesConfiguration;
    private final List<PsiElement> myResults = new SmartList();
    private final boolean myInspectionEnabled;

    public SpringProgrammaticConfigurationCollector(Project project) {
        this.myProject = project;
        this.myDetectionExcludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)project);
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)project);
        assert (profileManager.isProfileLoaded());
        this.myProfile = profileManager.getInspectionProfile();
        this.myInspectionEnabled = this.myProfile.isToolEnabled(HighlightDisplayKey.find((String)PROGRAMMATIC_CONFIG_INSPECTION.getID()));
    }

    public boolean isEnabledInProject() {
        return this.myInspectionEnabled;
    }

    public List<PsiElement> getResults() {
        return this.myResults;
    }

    public void collect(ProgressIndicator indicator) {
        this.collect(indicator, GlobalSearchScopesCore.projectProductionScope((Project)this.myProject));
    }

    public void collect(ProgressIndicator indicator, GlobalSearchScope searchScope) {
        Collection<PsiClass> applicationContextInheritors = this.findAllApplicationContextInheritors();
        if (applicationContextInheritors.isEmpty()) {
            return;
        }
        indicator.setText("Scanning for programmatic contexts...");
        indicator.setFraction(0.0);
        long start = System.currentTimeMillis();
        int i = 0;
        for (PsiClass inheritor : applicationContextInheritors) {
            this.collectCtorReferences(inheritor, (SearchScope)searchScope);
            indicator.setFraction((double)i++ / (double)applicationContextInheritors.size());
        }
        long end = System.currentTimeMillis();
        LOG.info("collect: " + (end - start) + "ms");
    }

    private Collection<PsiClass> findAllApplicationContextInheritors() {
        long start = System.currentTimeMillis();
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)this.myProject);
        PsiClass contextBaseClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(CONTEXT_BASE_CLASS, librariesScope);
        if (contextBaseClass == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope inheritorsScope = GlobalSearchScopesCore.projectProductionScope((Project)this.myProject).union((SearchScope)librariesScope);
        Query allContextImplementations = ClassInheritorsSearch.search((PsiClass)contextBaseClass, (SearchScope)inheritorsScope, (boolean)true);
        Collection all = allContextImplementations.findAll();
        all.add(contextBaseClass);
        long end = System.currentTimeMillis();
        LOG.info("findAllApplicationContextInheritors: " + (end - start) + "ms #" + all.size());
        return all;
    }

    private void collectCtorReferences(PsiClass contextPsiClass, SearchScope searchScope) {
        Query search = ReferencesSearch.search((PsiElement)contextPsiClass, (SearchScope)searchScope);
        search.forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                PsiElement expression = element.getParent();
                if (expression instanceof PsiAnonymousClass) {
                    expression = expression.getParent();
                }
                if (expression instanceof PsiNewExpression && !SpringProgrammaticConfigurationCollector.this.skipConfigInspectionFor(expression, PROGRAMMATIC_CONFIG_INSPECTION)) {
                    SpringProgrammaticConfigurationCollector.this.myResults.add(expression.getNavigationElement());
                }
                return true;
            }
        });
    }

    private boolean skipConfigInspectionFor(PsiElement place, LocalInspectionTool tool) {
        if (this.myDetectionExcludesConfiguration.isExcludedFromDetection(place.getContainingFile().getVirtualFile(), SpringFrameworkDetector.SPRING_FRAMEWORK_TYPE)) {
            return true;
        }
        HighlightDisplayKey toolHighlightDisplayKey = HighlightDisplayKey.find((String)tool.getID());
        return !this.myProfile.isToolEnabled(toolHighlightDisplayKey, place) || SuppressionUtil.inspectionResultSuppressed((PsiElement)place, (LocalInspectionTool)tool);
    }
}

