/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.factories.resolvers.FactoryPropertiesDependentTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.jee.SpringJeeElement;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJeeSchemaTypeResolver
implements ObjectTypeResolver {
    private FactoryPropertiesDependentTypeResolver myPropertyDependentResolver;

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        if (context instanceof SpringJeeElement) {
            Set<String> set = this.getJeeObjectType(context);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractJeeSchemaTypeResolver", "getObjectType"));
            }
            return set;
        }
        Set<String> set = this.getPropertyDependentResolver().getObjectType(context);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/AbstractJeeSchemaTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/AbstractJeeSchemaTypeResolver", "accept"));
        }
        return this.getFactoryClasses().contains(factoryClassName);
    }

    public FactoryPropertiesDependentTypeResolver getPropertyDependentResolver() {
        if (this.myPropertyDependentResolver == null) {
            this.myPropertyDependentResolver = new FactoryPropertiesDependentTypeResolver(this.getProperties());
        }
        return this.myPropertyDependentResolver;
    }

    protected abstract Set<String> getJeeObjectType(CommonSpringBean var1);

    protected abstract List<String> getProperties();

    protected abstract List<String> getFactoryClasses();
}

