/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiClassType;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransactionProxyFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.transaction.interceptor.TransactionProxyFactoryBean";
    @NonNls
    private static final String PROXY_INTERFACES_PROPERTY_NAME = "proxyInterfaces";
    @NonNls
    private static final String TARGET_PROPERTY_NAME = "target";

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        if (context instanceof SpringBean) {
            SpringBean springBean = (SpringBean)context;
            PsiClassType type = TransactionProxyFactoryBeanTypeResolver.getTargetType(springBean);
            if (type != null && TransactionProxyFactoryBeanTypeResolver.isCglibExplicitlyEnabled(springBean)) {
                Set<String> set = Collections.singleton(type.getCanonicalText());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
            Set<String> proxyInterfaceNames = TransactionProxyFactoryBeanTypeResolver.getTypesFromClassArrayProperty(springBean, PROXY_INTERFACES_PROPERTY_NAME);
            if (!proxyInterfaceNames.isEmpty()) {
                Set<String> set = proxyInterfaceNames;
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
            if (type != null) {
                Set<String> targetInterfaceNames = TransactionProxyFactoryBeanTypeResolver.getAllInterfaceNames(type);
                if (!targetInterfaceNames.isEmpty()) {
                    Set<String> set = targetInterfaceNames;
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver", "getObjectType"));
                    }
                    return set;
                }
                Set<String> set = Collections.singleton(type.getCanonicalText());
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver", "getObjectType"));
                }
                return set;
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver", "getObjectType"));
        }
        return set;
    }

    @Nullable
    private static PsiClassType getTargetType(@NotNull SpringBean context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver", "getTargetType"));
        }
        return TransactionProxyFactoryBeanTypeResolver.getTypeFromProperty(context, TARGET_PROPERTY_NAME);
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClassName", "com/intellij/spring/factories/resolvers/TransactionProxyFactoryBeanTypeResolver", "accept"));
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }
}

