/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.impl.SpringOuterModelsModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringModificationTrackersManagerImpl
extends SpringModificationTrackersManager {
    @NotNull
    private final Project myProject;
    private long myProfilesModificationCount;
    private final ModificationTracker myProfilesModificationTracker;
    private long myMultipleContextsModificationCount;
    private final ModificationTracker myMultipleContextsModificationTracker;
    private final ModificationTracker myOuterModelsModificationTracker;

    public SpringModificationTrackersManagerImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/impl/SpringModificationTrackersManagerImpl", "<init>"));
        }
        this.myProfilesModificationTracker = new ModificationTracker(){

            public long getModificationCount() {
                return SpringModificationTrackersManagerImpl.this.myProfilesModificationCount;
            }
        };
        this.myMultipleContextsModificationTracker = new ModificationTracker(){

            public long getModificationCount() {
                return SpringModificationTrackersManagerImpl.this.myMultipleContextsModificationCount;
            }
        };
        this.myProject = project;
        this.myOuterModelsModificationTracker = new SpringOuterModelsModificationTracker(project);
    }

    public ModificationTracker getProfilesModificationTracker() {
        return this.myProfilesModificationTracker;
    }

    public ModificationTracker getMultipleContextsModificationTracker() {
        return this.myMultipleContextsModificationTracker;
    }

    public ModificationTracker getOuterModelsModificationTracker() {
        return this.myOuterModelsModificationTracker;
    }

    public void fireActiveProfilesChanged() {
        ++this.myProfilesModificationCount;
    }

    public void fireMultipleContextsChanged() {
        ++this.myMultipleContextsModificationCount;
    }

    public Object[] getOuterModelsDependencies() {
        ArrayList dependencies = ContainerUtil.newArrayList();
        dependencies.add(this.getOuterModelsModificationTracker());
        dependencies.add(this.getProfilesModificationTracker());
        dependencies.add(this.getMultipleContextsModificationTracker());
        dependencies.add(ProjectRootManager.getInstance((Project)this.myProject));
        dependencies.add(FacetFinder.getInstance((Project)this.myProject).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
        return ArrayUtil.toObjectArray((Collection)dependencies);
    }
}

