/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.injection;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.context.Filter;
import com.intellij.spring.model.xml.context.Type;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Arrays;
import java.util.List;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;

public class SpringContextSchemaInjector
implements MultiHostInjector {
    private static final String EXPRESSION_ATTR_NAME = "expression";

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        Filter filter;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/injection/SpringContextSchemaInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/injection/SpringContextSchemaInjector", "getLanguagesToInject"));
        }
        PsiFile file = host.getContainingFile();
        if (!JamCommonUtil.isPlainXmlFile((PsiElement)file)) {
            return;
        }
        if (!(file instanceof XmlFile)) {
            return;
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) {
            return;
        }
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)host, XmlAttribute.class);
        if (xmlAttribute == null || !EXPRESSION_ATTR_NAME.equals(xmlAttribute.getLocalName())) {
            return;
        }
        GenericAttributeValue value = DomManager.getDomManager((Project)host.getProject()).getDomElement(xmlAttribute);
        if (value != null && (filter = (Filter)value.getParentOfType(Filter.class, true)) != null && Type.REGEX.equals(filter.getType().getValue())) {
            SpringContextSchemaInjector.injectRegexpLanguage(registrar, (PsiLanguageInjectionHost)host);
        }
    }

    private static void injectRegexpLanguage(@NotNull MultiHostRegistrar registrar, @NotNull PsiLanguageInjectionHost host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/injection/SpringContextSchemaInjector", "injectRegexpLanguage"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/injection/SpringContextSchemaInjector", "injectRegexpLanguage"));
        }
        registrar.startInjecting((Language)RegExpLanguage.INSTANCE).addPlace(null, null, host, ElementManipulators.getValueTextRange((PsiElement)host)).doneInjecting();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/injection/SpringContextSchemaInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

