/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerivedSpringBeanPointer
implements SpringBeanPointer {
    private final String myName;
    private final SpringBeanPointer myBasePointer;

    public DerivedSpringBeanPointer(@NotNull SpringBeanPointer basePointer, @NotNull String name) {
        if (basePointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePointer", "com/intellij/spring/model/DerivedSpringBeanPointer", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/DerivedSpringBeanPointer", "<init>"));
        }
        this.myBasePointer = basePointer;
        this.myName = name;
    }

    public SpringBeanPointer derive(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/DerivedSpringBeanPointer", "derive"));
        }
        if (name.equals(this.myName)) {
            return this;
        }
        if (name.equals(this.myBasePointer.getName())) {
            return this.myBasePointer;
        }
        return new DerivedSpringBeanPointer(this.myBasePointer, name);
    }

    public String[] getAliases() {
        return this.myBasePointer.getAliases();
    }

    public boolean isReferenceTo(@Nullable CommonSpringBean springBean) {
        return this.myBasePointer.isReferenceTo(springBean);
    }

    @NotNull
    public SpringBeanPointer getBasePointer() {
        SpringBeanPointer springBeanPointer = this.myBasePointer;
        if (springBeanPointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/DerivedSpringBeanPointer", "getBasePointer"));
        }
        return springBeanPointer;
    }

    public boolean isValid() {
        return this.myBasePointer.isValid();
    }

    @Nullable
    public PsiClass getBeanClass() {
        return this.myBasePointer.getBeanClass();
    }

    public PsiFile getContainingFile() {
        return this.myBasePointer.getContainingFile();
    }

    public PsiClass[] getEffectiveBeanType() {
        return this.myBasePointer.getEffectiveBeanType();
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public SpringBeanPointer getParentPointer() {
        return this.myBasePointer.getParentPointer();
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myBasePointer.getPsiElement();
    }

    @NotNull
    public CommonSpringBean getSpringBean() {
        CommonSpringBean commonSpringBean = this.myBasePointer.getSpringBean();
        if (commonSpringBean == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/DerivedSpringBeanPointer", "getSpringBean"));
        }
        return commonSpringBean;
    }

    public boolean isAbstract() {
        return this.myBasePointer.isAbstract();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DerivedSpringBeanPointer)) {
            return false;
        }
        DerivedSpringBeanPointer that = (DerivedSpringBeanPointer)o;
        if (!this.myBasePointer.equals(that.myBasePointer)) {
            return false;
        }
        return this.myName.equals(that.myName);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myBasePointer.hashCode();
        return result;
    }
}

