/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiClass;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringFactoryBeansEffectiveTypesProviders
extends SpringBeanEffectiveTypeProvider {
    public void processEffectiveTypes(@NotNull CommonSpringBean bean, Collection<PsiClass> result) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/SpringFactoryBeansEffectiveTypesProviders", "processEffectiveTypes"));
        }
        PsiClass beanClass = bean.getBeanClass();
        if (beanClass == null || !SpringFactoryBeansManager.getInstance().isFactoryBeanClass(beanClass)) {
            return;
        }
        result.clear();
        ContainerUtil.addAll(result, (Object[])SpringFactoryBeansManager.getInstance().getProductTypes(beanClass, bean));
    }
}

