/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkSupportProvider;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkSupportTemplatesRunner;
import com.intellij.spring.model.actions.patterns.frameworks.ui.ChooseTemplatesDialogWrapper;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.actions.generate.AbstractDomGenerateProvider;
import com.intellij.xml.util.XmlTagUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FrameworkSupportTemplatesRunnerImpl
extends FrameworkSupportTemplatesRunner {
    public void generateSpringBeans(final FrameworkSupportProvider provider, final Module module, final Editor editor, final XmlFile xmlFile) {
        final ChooseTemplatesDialogWrapper dialogWrapper = new ChooseTemplatesDialogWrapper(module.getProject(), provider.getTemplateInfos(module), provider.getLibrariesInfo(module), provider.getDescription());
        dialogWrapper.show();
        if (dialogWrapper.getExitCode() == 0) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)xmlFile)) {
                return;
            }
            new WriteCommandAction(module.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/actions/patterns/frameworks/FrameworkSupportTemplatesRunnerImpl$1", "run"));
                    }
                    provider.addFacet(module);
                    dialogWrapper.getTemplatesForm().getLibrariesValidationComponent().setupLibraries();
                    FrameworkSupportTemplatesRunnerImpl.moveCaretIfNeeded(module.getProject(), editor, xmlFile);
                    FrameworkSupportTemplatesRunnerImpl.runTemplates(module.getProject(), editor, dialogWrapper.getSelectedTemplates(), 0, provider.getPredefinedVars(module, xmlFile));
                }
            }.execute();
        }
    }

    private static void moveCaretIfNeeded(Project project, Editor editor, XmlFile xmlFile) {
        DomSpringBean bean = SpringBeanCoreUtils.getSpringBeanForCurrentCaretPosition(editor, (PsiFile)xmlFile);
        if (bean != null) {
            DomSpringBean springBean = SpringBeanCoreUtils.getTopLevelBean(bean);
            if (springBean.getXmlTag() != null) {
                TextRange range = springBean.getXmlTag().getTextRange();
                int offset = range.getEndOffset();
                editor.getCaretModel().moveToOffset(offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        } else {
            XmlTag tag;
            PsiElement element = xmlFile.findElementAt(editor.getCaretModel().getOffset());
            Beans beans = (Beans)DomUtil.findDomElement((PsiElement)element, Beans.class);
            if (beans != null && (tag = beans.getXmlTag()) != null) {
                int offset = XmlTagUtil.getTrimmedValueRange((XmlTag)tag).getStartOffset();
                editor.getCaretModel().moveToOffset(tag.getTextRange().getStartOffset() + offset);
                editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        }
    }

    private static void runTemplates(final Project project, final Editor editor, final List<Template> templates, final int index, final Map<String, String> predefinedVars) {
        Template template = templates.get(index);
        template.setToReformat(true);
        TemplateManager.getInstance((Project)project).startTemplate(editor, template, true, predefinedVars, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                if (index + 1 < templates.size()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new WriteCommandAction(project, new PsiFile[0]){

                                protected void run(@NotNull Result result) throws Throwable {
                                    if (result == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/actions/patterns/frameworks/FrameworkSupportTemplatesRunnerImpl$2$1$1", "run"));
                                    }
                                    FrameworkSupportTemplatesRunnerImpl.runTemplates(project, editor, templates, index + 1, predefinedVars);
                                }
                            }.execute();
                        }
                    });
                }
            }
        });
    }

    @NotNull
    public Map<String, String> getPredefinedVars(Module module, XmlFile xmlFile) {
        DomFileElement root;
        HashMap vars = new HashMap();
        LocalXmlModel springModel = SpringManager.getInstance((Project)module.getProject()).getLocalSpringModel(xmlFile);
        if (springModel != null && (root = springModel.getRoot()) != null) {
            AbstractDomGenerateProvider.addNamespacePrefix((DomElement)root.getRootElement(), (Map)vars);
        }
        HashMap hashMap = vars;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/patterns/frameworks/FrameworkSupportTemplatesRunnerImpl", "getPredefinedVars"));
        }
        return hashMap;
    }
}

