/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanIdConverter;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverter;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverterImpl;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.beans.TypeHolder;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanIdConverterImpl
extends SpringBeanIdConverter {
    private static final FieldRetrievingFactoryBeanConverterImpl.FactoryClassCondition CONDITION = new FieldRetrievingFactoryBeanConverterImpl.FactoryClassCondition();
    private static final FieldRetrievingFactoryBeanConverter CONVERTER = new FieldRetrievingFactoryBeanConverterImpl(true);

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> genericDomValue, PsiElement element, ConvertContext context) {
        if (genericDomValue.getParent() instanceof CustomBeanWrapper) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanIdConverterImpl", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (CONDITION.value((GenericDomValue)context.getInvocationElement())) {
            PsiReference[] psiReferenceArray = CONVERTER.createReferences(genericDomValue, element, context);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanIdConverterImpl", "createReferences"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new BeanIdReference(element, genericDomValue)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanIdConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static List<String> suggestUnusedBeanNames(@Nullable DomSpringBean springBean) {
        if (springBean == null) {
            return Collections.emptyList();
        }
        PsiClass beanClass = springBean.getBeanClass();
        PsiClassType psiType = beanClass == null ? null : PsiTypesUtil.getClassType((PsiClass)beanClass);
        Collection list = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)springBean).getAllCommonBeans();
        ArrayList<String> unusedReferences = new ArrayList<String>();
        for (SpringBeanPointer pointer : list) {
            CommonSpringBean bean = pointer.getSpringBean();
            if (!(bean instanceof DomSpringBean)) continue;
            DomSpringBean domSpringBean = (DomSpringBean)bean;
            for (SpringValueHolderDefinition definition : DomUtil.getDefinedChildrenOfType((DomElement)domSpringBean, SpringValueHolderDefinition.class)) {
                GenericDomValue refElement = definition.getRefElement();
                if (refElement == null || StringUtil.isEmptyOrSpaces((String)refElement.getStringValue()) || refElement.getValue() != null) continue;
                String unusedBeanRef = refElement.getStringValue();
                if (psiType != null) {
                    PsiType requiredType = TypeHolderUtil.getRequiredType((TypeHolder)definition);
                    if (requiredType == null || !requiredType.isAssignableFrom((PsiType)psiType)) continue;
                    unusedReferences.add(unusedBeanRef);
                    continue;
                }
                unusedReferences.add(unusedBeanRef);
            }
        }
        return unusedReferences;
    }

    private static class BeanIdReference
    extends PsiReferenceBase<PsiElement>
    implements ResolvingHint {
        private final GenericDomValue<String> myGenericDomValue;

        private BeanIdReference(PsiElement element, GenericDomValue<String> genericDomValue) {
            super(element, true);
            this.myGenericDomValue = genericDomValue;
        }

        public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
            return ReflectionUtil.isAssignable(PomTargetPsiElement.class, elementClass);
        }

        public PsiElement resolve() {
            DomSpringBean springBean = this.getDomSpringBean();
            return springBean == null ? null : BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)springBean).getPsiElement();
        }

        @NotNull
        public Object[] getVariants() {
            DomSpringBean springBean = this.getDomSpringBean();
            List names = SpringBeanIdConverterImpl.suggestUnusedBeanNames(springBean);
            ContainerUtil.addAll((Collection)names, (Object[])SpringBeanCoreUtils.suggestBeanNames((CommonSpringBean)springBean));
            Object[] objectArray = ArrayUtil.toStringArray((Collection)names);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanIdConverterImpl$BeanIdReference", "getVariants"));
            }
            return objectArray;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/converters/SpringBeanIdConverterImpl$BeanIdReference", "bindToElement"));
            }
            return element;
        }

        private DomSpringBean getDomSpringBean() {
            return (DomSpringBean)this.myGenericDomValue.getParentOfType(DomSpringBean.class, false);
        }
    }
}

