/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanLookupMethodConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanLookupMethodConverterImpl
extends SpringBeanLookupMethodConverter {
    @Nullable
    protected PsiClass getPsiClass(ConvertContext context) {
        SpringBean springBean = (SpringBean)context.getInvocationElement().getParentOfType(SpringBean.class, false);
        return springBean != null ? springBean.getBeanClass() : null;
    }

    protected boolean checkModifiers(PsiMethod method) {
        return method.hasModifierProperty("public") || method.hasModifierProperty("protected");
    }

    protected boolean checkReturnType(ConvertContext context, PsiMethod method, boolean forCompletion) {
        PsiClass[] possibleReturnTypes;
        PsiType returnType = method.getReturnType();
        if (PsiType.VOID.equals((Object)returnType) || returnType instanceof PsiPrimitiveType) {
            return false;
        }
        if (forCompletion && (possibleReturnTypes = SpringBeanLookupMethodConverterImpl.getValidReturnTypes(context)).length > 0 && returnType != null) {
            for (PsiClass possibleReturnType : possibleReturnTypes) {
                PsiClassType classType = PsiTypesUtil.getClassType((PsiClass)possibleReturnType);
                if (!classType.isAssignableFrom(returnType)) continue;
                return true;
            }
            return false;
        }
        return super.checkReturnType(context, method, forCompletion);
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        PsiClass[] validReturnTypes = SpringBeanLookupMethodConverterImpl.getValidReturnTypes(context);
        if (validReturnTypes.length == 0) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        DomSpringBean springBean = SpringConverterUtil.getCurrentBean((ConvertContext)context);
        if (springBean == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        PsiClass psiClass = springBean.getBeanClass();
        String elementName = element.getStringValue();
        if (psiClass == null || elementName == null || StringUtil.isEmpty((String)elementName)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<CreateMethodQuickFix> fixes = new ArrayList<CreateMethodQuickFix>();
        for (PsiClass returnType : validReturnTypes) {
            CreateMethodQuickFix fix = CreateMethodQuickFix.createFix((PsiClass)psiClass, (String)SpringBeanLookupMethodConverterImpl.getNewMethodSignature(elementName, returnType), (String)SpringBeanLookupMethodConverterImpl.getNewMethodBody());
            if (fix == null) continue;
            fixes.add(fix);
        }
        return fixes.toArray(new LocalQuickFix[fixes.size()]);
    }

    @NonNls
    private static String getNewMethodBody() {
        return "return null;";
    }

    @NonNls
    private static String getNewMethodSignature(@NotNull String elementName, @NotNull PsiClass psiClass) {
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "com/intellij/spring/model/converters/SpringBeanLookupMethodConverterImpl", "getNewMethodSignature"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/converters/SpringBeanLookupMethodConverterImpl", "getNewMethodSignature"));
        }
        return "public " + psiClass.getQualifiedName() + " " + elementName + "()";
    }

    @NotNull
    private static PsiClass[] getValidReturnTypes(ConvertContext context) {
        SpringBeanPointer beanPointer;
        LookupMethod lookupMethod = (LookupMethod)context.getInvocationElement().getParentOfType(LookupMethod.class, false);
        if (lookupMethod != null && (beanPointer = (SpringBeanPointer)lookupMethod.getBean().getValue()) != null) {
            PsiClass[] psiClassArray = beanPointer.getEffectiveBeanType();
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanLookupMethodConverterImpl", "getValidReturnTypes"));
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanLookupMethodConverterImpl", "getValidReturnTypes"));
        }
        return PsiClass.EMPTY_ARRAY;
    }
}

