/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.actions.generate.SpringTemplateBuilder;
import com.intellij.spring.model.highlighting.ResolvedConstructorArgsMessageBuilder;
import com.intellij.spring.model.highlighting.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.actions.generate.AbstractDomGenerateProvider;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringConstructorArgInspection
extends SpringBeanInspectionBase {
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringBeanConstructorArgInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection", "getShortName"));
        }
        return "SpringBeanConstructorArgInspection";
    }

    protected void checkBean(SpringBean springBean, Beans beans, DomElementAnnotationHolder holder, XmlSpringModel springModel) {
        PsiClass beanClass = springBean.getBeanClass();
        if (beanClass != null) {
            SpringConstructorArgInspection.checkConstructorResolve(springBean, holder, beanClass);
            SpringConstructorArgInspection.checkConstructorArgType(springBean, holder);
        }
        SpringConstructorArgInspection.checkConstructorArgIndexes(springBean, holder);
    }

    private static void checkConstructorResolve(@NotNull SpringBean springBean, DomElementAnnotationHolder holder, @NotNull PsiClass beanClass) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection", "checkConstructorResolve"));
        }
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection", "checkConstructorResolve"));
        }
        if (springBean.isAbstract()) {
            return;
        }
        ResolvedConstructorArgs resolvedArgs = springBean.getResolvedConstructorArgs();
        if (!resolvedArgs.isResolved()) {
            boolean instantiatedByFactory = SpringConstructorArgInspection.isInstantiatedByFactory(springBean);
            String basicMessage = instantiatedByFactory ? SpringBundle.message("cannot.find.factory.method.with.parameters.count", beanClass.getName()) : SpringBundle.message("cannot.find.bean.constructor.with.parameters.count", beanClass.getName());
            ResolvedConstructorArgsMessageBuilder messageBuilder = new ResolvedConstructorArgsMessageBuilder(basicMessage, beanClass, resolvedArgs);
            String message = messageBuilder.getMessage();
            Object element = !instantiatedByFactory && DomUtil.hasXml((DomElement)springBean.getClazz()) ? springBean.getClazz() : (instantiatedByFactory && DomUtil.hasXml((DomElement)springBean.getFactoryMethod()) ? springBean.getFactoryMethod() : springBean);
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            SpringBean stableCopy = (SpringBean)springBean.createStableCopy();
            if (!instantiatedByFactory && !(beanClass instanceof PsiCompiledElement)) {
                fixes.add(SpringConstructorArgInspection.createConstructorQuickFix(stableCopy, beanClass));
            }
            fixes.addAll(SpringConstructorArgInspection.getConstructorArgsQuickFixes(stableCopy, springBean.getInstantiationMethods()));
            holder.createProblem((DomElement)element, HighlightSeverity.ERROR, message, fixes.toArray(new LocalQuickFix[fixes.size()]));
        }
    }

    private static boolean isInstantiatedByFactory(SpringBean springBean) {
        return DomUtil.hasXml((DomElement)springBean.getFactoryMethod());
    }

    private static void checkConstructorArgType(SpringBean springBean, DomElementAnnotationHolder holder) {
        List list = springBean.getConstructorArgs();
        if (list.isEmpty()) {
            return;
        }
        List instantiationMethods = springBean.getInstantiationMethods();
        block0: for (ConstructorArg arg : list) {
            PsiType argType = (PsiType)arg.getType().getValue();
            if (argType == null) continue;
            Integer index = (Integer)arg.getIndex().getValue();
            boolean parameterFound = false;
            if (index != null) {
                int i = index;
                if (i < 0) continue;
                for (PsiMethod method : instantiationMethods) {
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (i >= parameters.length) continue;
                    parameterFound = true;
                    if (!parameters[i].getType().isAssignableFrom(argType)) continue;
                    continue block0;
                }
            } else {
                for (PsiMethod method : instantiationMethods) {
                    PsiParameter[] parameters;
                    for (PsiParameter param : parameters = method.getParameterList().getParameters()) {
                        if (param.getType().isAssignableFrom(argType)) continue block0;
                    }
                }
            }
            if (!parameterFound) continue;
            String message = SpringBundle.message("constructor.arg.incorrect.value.type", new Object[0]);
            holder.createProblem((DomElement)arg.getType(), message, new LocalQuickFix[0]);
        }
    }

    private static void checkConstructorArgIndexes(SpringBean springBean, DomElementAnnotationHolder holder) {
        List list = springBean.getConstructorArgs();
        if (list.isEmpty()) {
            return;
        }
        HashMap<Integer, ConstructorArg> argsMap = new HashMap<Integer, ConstructorArg>();
        SmartList firstSeen = new SmartList();
        for (ConstructorArg arg : list) {
            ConstructorArg previous;
            Integer index = (Integer)arg.getIndex().getValue();
            if (index == null || (previous = argsMap.put(index, arg)) == null) continue;
            SpringConstructorArgInspection.reportNotUniqueIndex(holder, arg);
            if (firstSeen.contains(previous)) continue;
            SpringConstructorArgInspection.reportNotUniqueIndex(holder, previous);
            firstSeen.add(previous);
        }
    }

    private static void reportNotUniqueIndex(DomElementAnnotationHolder holder, ConstructorArg arg) {
        String message = SpringBundle.message("incorrect.constructor.arg.index.not.unique", new Object[0]);
        holder.createProblem((DomElement)arg.getIndex(), message, new LocalQuickFix[0]);
    }

    private static LocalQuickFix createConstructorQuickFix(final SpringBean springBean, PsiClass beanClass) {
        String params = SpringConstructorArgResolveUtil.suggestParamsForConstructorArgsAsString(springBean);
        final String signature = beanClass.getName() + "(" + params + ")";
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.create.constructor.quickfix.message", signature);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection$1", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("model.create.constructor.quickfix.message.family.name", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection$1", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection$1", "applyFix"));
                }
                PsiClass beanClass = springBean.getBeanClass();
                try {
                    assert (beanClass != null);
                    if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)beanClass.getContainingFile())) {
                        return;
                    }
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)beanClass.getProject()).getElementFactory();
                    PsiMethod constructor = elementFactory.createConstructor();
                    List<PsiParameter> parameters = SpringConstructorArgResolveUtil.suggestParamsForConstructorArgs(springBean);
                    for (PsiParameter parameter : parameters) {
                        constructor.getParameterList().add((PsiElement)parameter);
                    }
                    beanClass.add((PsiElement)constructor);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static List<LocalQuickFix> getConstructorArgsQuickFixes(@NotNull SpringBean springBean, @NotNull List<PsiMethod> ctors) {
        if (springBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springBean", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection", "getConstructorArgsQuickFixes"));
        }
        if (ctors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctors", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection", "getConstructorArgsQuickFixes"));
        }
        if (!springBean.getConstructorArgs().isEmpty() || !springBean.getCNamespaceConstructorArgDefinitions().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
        for (PsiMethod ctor : ctors) {
            if (ctor.getParameterList().getParametersCount() <= 0) continue;
            quickFixes.add(new AddConstructorArgQuickFix(ctor, springBean));
        }
        return quickFixes;
    }

    public static class AddConstructorArgQuickFix
    implements LocalQuickFix {
        private final SpringBean mySpringBean;
        private final String myMethodName;
        private final SmartPsiElementPointer<PsiMethod> myCtorPointer;

        public AddConstructorArgQuickFix(PsiMethod ctor, SpringBean springBean) {
            this.myCtorPointer = SmartPointerManager.getInstance((Project)ctor.getProject()).createSmartPsiElementPointer((PsiElement)ctor);
            this.mySpringBean = springBean;
            this.myMethodName = PsiFormatUtil.formatMethod((PsiMethod)ctor, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.add.constructor.args.for.method.quickfix.message", this.myMethodName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection$AddConstructorArgQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("model.add.constructor.args.for.method.quickfix.message.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection$AddConstructorArgQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection$AddConstructorArgQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/highlighting/SpringConstructorArgInspection$AddConstructorArgQuickFix", "applyFix"));
            }
            PsiMethod ctor = (PsiMethod)this.myCtorPointer.getElement();
            if (ctor == null || !ctor.isValid()) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(this.mySpringBean.getContainingFile())) {
                return;
            }
            PsiMethod[] myAllCtors = ctor.getContainingClass().getConstructors();
            PsiParameter[] parameters = ctor.getParameterList().getParameters();
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)this.mySpringBean);
            SpringTemplateBuilder builder = new SpringTemplateBuilder(project);
            Editor editor = SpringTemplateBuilder.getEditor(descriptor);
            SpringTemplateBuilder.preparePlace(editor, project, (DomElement)this.mySpringBean.addConstructorArg());
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                builder.addTextSegment("<");
                builder.addVariableSegment("NS_PREFIX");
                builder.addTextSegment("constructor-arg");
                if (parameters.length > 1) {
                    builder.addTextSegment(" index=\"" + i + "\"");
                }
                for (PsiMethod allCtor : myAllCtors) {
                    PsiParameter[] params;
                    if (allCtor == ctor || (params = allCtor.getParameterList().getParameters()).length != parameters.length) continue;
                    builder.addTextSegment(" type=\"" + parameters[i].getType().getCanonicalText() + "\"");
                    break;
                }
                builder.createValueAndClose(parameter.getType(), model, "constructor-arg");
            }
            builder.startTemplate(editor, AbstractDomGenerateProvider.createNamespacePrefixMap((DomElement)this.mySpringBean));
        }
    }
}

