/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.CanonicalPsiTypeConverter;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.ExtendsClassChecker;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringModelInspection
extends BasicDomElementsInspection<Beans> {
    public SpringModelInspection() {
        super(Beans.class, new Class[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringModelInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringModelInspection", "getShortName"));
        }
        return "SpringModelInspection";
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        Converter converter;
        int oldSize = holder.getSize();
        super.checkDomElement(element, holder, helper);
        if (oldSize != holder.getSize() || !(element instanceof GenericDomValue)) {
            return;
        }
        if (element.getAnnotation(Convert.class) != null && ((converter = ((GenericDomValue)element).getConverter()) instanceof PsiClassConverter || converter instanceof CanonicalPsiTypeConverter)) {
            return;
        }
        ExtendsClassChecker.checkExtendsClassInReferences((GenericDomValue)((GenericDomValue)element), (DomElementAnnotationHolder)holder);
    }

    private static boolean hasInjections(GenericDomValue value) {
        if (StringUtil.isEmptyOrSpaces((String)value.getRawText())) {
            return false;
        }
        XmlElement element = value.getXmlElement();
        if (element instanceof XmlAttribute) {
            element = ((XmlAttribute)element).getValueElement();
        }
        return element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element));
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value) {
        return !SpringBeanScope.class.equals((Object)DomUtil.getGenericValueParameter((Type)value.getDomElementType())) && super.shouldCheckResolveProblems(value) && SpringProfileUtils.isInActiveProfile((DomElement)value) && !PlaceholderUtils.getInstance().isPlaceholder(value) && !SpringModelInspection.hasInjections(value);
    }
}

