/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAutowiredBeanFindUsagesHandler
extends FindUsagesHandler {
    public SpringAutowiredBeanFindUsagesHandler(PsiElement psiMember) {
        super(psiMember);
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler", "processElementUsages"));
        }
        if (!super.processElementUsages(element, processor, options)) {
            return false;
        }
        SpringBeanPointer pointer = (SpringBeanPointer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SpringBeanPointer>(){

            @Nullable
            public SpringBeanPointer compute() {
                CommonSpringBean bean = SpringBeanUtils.getInstance().findBean(SpringAutowiredBeanFindUsagesHandler.this.getPsiElement());
                if (bean == null) {
                    return null;
                }
                return BeanService.getInstance().createSpringBeanPointer(bean);
            }
        });
        if (pointer == null) {
            return true;
        }
        return SpringAutowiredBeanFindUsagesHandler.processAutowiredBeans(element, processor, options, pointer);
    }

    public static boolean processAutowiredBeans(final PsiElement element, final @NotNull Processor<UsageInfo> processor, final FindUsagesOptions options, final SpringBeanPointer pointer) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler", "processAutowiredBeans"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    return true;
                }
                final MultiMap injectionPoints = new MultiMap();
                GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
                for (String anno : SpringAutowireUtil.getAutowiredAnnotations(module)) {
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)element.getProject()).findClass(anno, scope);
                    if (psiClass == null) continue;
                    AnnotatedElementsSearch.searchPsiMembers((PsiClass)psiClass, (SearchScope)options.searchScope).forEach((Processor)new Processor<PsiMember>(){

                        public boolean process(PsiMember member) {
                            PsiClass containingClass = member.getContainingClass();
                            if (containingClass != null) {
                                injectionPoints.putValue((Object)containingClass, (Object)member);
                            }
                            return true;
                        }
                    });
                }
                if (injectionPoints.size() > 0) {
                    PsiClass[] effectiveBeanTypes = pointer.getEffectiveBeanType();
                    for (Map.Entry entry : injectionPoints.entrySet()) {
                        PsiClass psiClass = (PsiClass)entry.getKey();
                        CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel((PsiElement)psiClass);
                        for (PsiMember psiMember : (Collection)entry.getValue()) {
                            PsiParameter[] parameters;
                            if (psiMember instanceof PsiField && SpringAutowiredBeanFindUsagesHandler.isAutowiredUsage((PsiVariable)((PsiField)psiMember), pointer, springModel, effectiveBeanTypes) && !processor.process((Object)new UsageInfo((PsiElement)psiMember))) {
                                return false;
                            }
                            if (!(psiMember instanceof PsiMethod)) continue;
                            for (PsiParameter parameter : parameters = ((PsiMethod)psiMember).getParameterList().getParameters()) {
                                if (!SpringAutowiredBeanFindUsagesHandler.isAutowiredUsage((PsiVariable)parameter, pointer, springModel, effectiveBeanTypes) || processor.process((Object)new UsageInfo((PsiElement)parameter))) continue;
                                return false;
                            }
                        }
                    }
                }
                return true;
            }
        });
    }

    private static boolean isAutowiredUsage(@NotNull PsiVariable variable, @NotNull SpringBeanPointer pointer, @NotNull CommonSpringModel model, @NotNull PsiClass[] effectiveBeanTypes) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler", "isAutowiredUsage"));
        }
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler", "isAutowiredUsage"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler", "isAutowiredUsage"));
        }
        if (effectiveBeanTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveBeanTypes", "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler", "isAutowiredUsage"));
        }
        boolean isAssignable = false;
        PsiType variableType = SpringAutowireUtil.getAutowiredEffectiveBeanTypes(variable.getType());
        for (PsiClass aClass : effectiveBeanTypes) {
            if (!variableType.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)aClass))) continue;
            isAssignable = true;
            break;
        }
        return isAssignable && SpringAutowireUtil.autowireByType(model, variableType, variable.getName()).contains(pointer);
    }
}

