/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.jam.SpringSemContributorUtil;
import com.intellij.spring.model.jam.componentScan.CustomJamComponentScan;
import com.intellij.spring.model.jam.contexts.CustomContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.javaConfig.JavaConfigConfiguration;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringCdiNamed;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringImportResource;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringManagedBean;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringService;
import com.intellij.spring.model.jam.testContexts.CustomContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTransactionConfiguration;
import com.intellij.spring.model.jam.transaction.SpringTransactionalComponent;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.util.Collection;
import java.util.Collections;

public class SpringSemContributor
extends SemContributor {
    private final SemService mySemService;

    public SpringSemContributor(SemService semService, UltimateVerifier verifier) {
        this.mySemService = semService;
        PluginVerifier.verifyUltimatePlugin(verifier);
    }

    public void registerSemProviders(SemRegistrar registrar) {
        PsiClassPattern nonAnnoClass = (PsiClassPattern)PsiJavaPatterns.psiClass().nonAnnotationType().withoutModifiers(new String[]{"private"});
        PsiClassPattern classPattern = (PsiClassPattern)PsiJavaPatterns.psiClass().withoutModifiers(new String[]{"private"});
        SpringComponent.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.stereotype.Component"));
        this.registerConfigurations(registrar);
        this.registerServices(registrar, nonAnnoClass);
        this.registerControllers(registrar, nonAnnoClass);
        this.registerRepositories(registrar, nonAnnoClass);
        this.registerCustomComponents(registrar, nonAnnoClass);
        this.registerCustomContextConfigurations(registrar, nonAnnoClass);
        this.registerCustomComponentScans(registrar, nonAnnoClass);
        SpringCdiNamed.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("javax.inject.Named"));
        this.registerContextJavaBeans(registrar);
        SpringEventListener.METHOD_META.register(registrar, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().constructor(false).withModifiers(new String[]{"public"})).withAnnotation("org.springframework.context.event.EventListener"));
        SpringAliasFor.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.core.annotation.AliasFor"));
        SpringImport.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.Import"));
        SpringImportResource.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.ImportResource"));
        SpringJamComponentScan.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.context.annotation.ComponentScan"));
        SpringPropertySource.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.context.annotation.PropertySource"));
        JavaConfigConfiguration.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.config.java.annotation.Configuration"));
        SpringContextConfiguration.META.register(registrar, (ElementPattern)classPattern.withAnnotation("org.springframework.test.context.ContextConfiguration"));
        SpringContextHierarchy.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.ContextHierarchy"));
        SpringTransactionConfiguration.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.test.context.transaction.TransactionConfiguration"));
        SpringTransactionalComponent.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("org.springframework.transaction.annotation.Transactional"));
        SpringManagedBean.META.register(registrar, (ElementPattern)nonAnnoClass.withAnnotation("javax.annotation.ManagedBean"));
    }

    private void registerContextJavaBeans(SemRegistrar registrar) {
        ContextJavaBean.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotation("org.springframework.context.annotation.Bean"));
        this.registerCustomContextJavaBean(registrar, PsiJavaPatterns.psiMethod());
    }

    private void registerCustomComponents(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)CustomSpringComponent.META_KEY, (SemKey)CustomSpringComponent.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)CustomSpringComponent.JAM_KEY, CustomSpringComponent.class, SpringSemContributor.getUserDefinedCustomAnnotations(), (Function)new Function<Pair<String, PsiClass>, CustomSpringComponent>(){

            public CustomSpringComponent fun(Pair<String, PsiClass> pair) {
                return new CustomSpringComponent((String)pair.first, (PsiClass)pair.second);
            }
        }, (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerCustomComponentScans(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, CustomJamComponentScan.META_KEY, CustomJamComponentScan.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(CustomJamComponentScan.JAM_KEY, CustomJamComponentScan.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.context.annotation.ComponentScan"), (Function)new Function<Pair<String, PsiClass>, CustomJamComponentScan>(){

            public CustomJamComponentScan fun(Pair<String, PsiClass> pair) {
                return new CustomJamComponentScan((String)pair.first, (PsiClass)pair.second);
            }
        }, null));
    }

    private void registerCustomContextConfigurations(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)CustomContextConfiguration.META_KEY, (SemKey)CustomContextConfiguration.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)CustomContextConfiguration.JAM_KEY, CustomContextConfiguration.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.test.context.ContextConfiguration", (boolean)true), (Function)new Function<Pair<String, PsiClass>, CustomContextConfiguration>(){

            public CustomContextConfiguration fun(Pair<String, PsiClass> pair) {
                return new CustomContextConfiguration((String)pair.first, (PsiClass)pair.second);
            }
        }, null));
    }

    private void registerCustomContextJavaBean(SemRegistrar registrar, PsiMethodPattern pattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)pattern, CustomContextJavaBean.META_KEY, CustomContextJavaBean.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(CustomContextJavaBean.JAM_KEY, CustomContextJavaBean.class, (Function)SpringSemContributorUtil.getCustomMetaAnnotations((String)"org.springframework.context.annotation.Bean"), (Function)new Function<Pair<String, PsiMethod>, CustomContextJavaBean>(){

            public CustomContextJavaBean fun(Pair<String, PsiMethod> pair) {
                return new CustomContextJavaBean((String)pair.first, (PsiMethod)pair.second);
            }
        }, null));
    }

    private void registerConfigurations(SemRegistrar registrar) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)SpringConfiguration.PSI_CLASS_PATTERN, (SemKey)SpringConfiguration.META_KEY, (SemKey)SpringConfiguration.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)SpringConfiguration.JAM_KEY, SpringConfiguration.class, (Function)SpringConfiguration.getAnnotations(), (Function)SpringConfiguration.getProducer(), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerControllers(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)SpringController.META_KEY, (SemKey)SpringController.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)SpringController.JAM_KEY, SpringController.class, (Function)SpringController.getControllerAnnotations(), (Function)SpringController.getControllerProducer(), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerRepositories(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, SpringRepository.META_KEY, SpringRepository.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction(SpringRepository.JAM_KEY, SpringRepository.class, SpringRepository.getRepositoryAnnotations(), SpringRepository.getRepositoryProducer(), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private void registerServices(SemRegistrar registrar, PsiClassPattern psiClassPattern) {
        SpringSemContributorUtil.registerMetaComponents((SemService)this.mySemService, (SemRegistrar)registrar, (ElementPattern)psiClassPattern, (SemKey)SpringService.META_KEY, (SemKey)SpringService.JAM_KEY, (NullableFunction)SpringSemContributorUtil.createFunction((SemKey)SpringService.JAM_KEY, SpringService.class, (Function)SpringService.getServiceAnnotations(), (Function)SpringService.getServiceProducer(), (Consumer)SpringSemContributorUtil.createStereotypeConsumer()));
    }

    private static Function<Module, Collection<String>> getUserDefinedCustomAnnotations() {
        return new Function<Module, Collection<String>>(){

            public Collection<String> fun(Module module) {
                return module == null ? Collections.emptySet() : JamAnnotationTypeUtil.getInstance((Module)module).getUserDefinedCustomComponentAnnotations();
            }
        };
    }
}

