/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamAnnotationTypeUtilImpl
extends JamAnnotationTypeUtil {
    @NonNls
    private static final String[] DEFAULT_SPRING_COMPONENTS = new String[]{"org.springframework.stereotype.Component", "org.springframework.stereotype.Controller", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Service", "org.springframework.config.java.annotation.Configuration", "org.springframework.context.annotation.Configuration", "javax.inject.Named"};
    private final Map<String, Key<CachedValue<Collection<PsiClass>>>> cachedKeyMap = new ConcurrentFactoryMap<String, Key<CachedValue<Collection<PsiClass>>>>(){

        @Nullable
        protected Key<CachedValue<Collection<PsiClass>>> create(String key) {
            return Key.create((String)("SPRING_MODULE_ANNOTATIONS:" + key));
        }
    };
    private final Module myModule;

    public JamAnnotationTypeUtilImpl(Module module) {
        this.myModule = module;
    }

    @NotNull
    public List<PsiClass> getQualifierAnnotationTypesWithChildren() {
        SmartList list = new SmartList();
        list.addAll(this.getAnnotationTypesWithChildren("org.springframework.beans.factory.annotation.Qualifier"));
        list.addAll(this.getAnnotationTypesWithChildren("javax.inject.Qualifier"));
        list.addAll(this.getImplicitQualifierAnnotations());
        SmartList smartList = list;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl", "getQualifierAnnotationTypesWithChildren"));
        }
        return smartList;
    }

    private List<PsiClass> getImplicitQualifierAnnotations() {
        return (List)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, (CachedValueProvider)new CachedValueProvider<List<PsiClass>>(){

            @Nullable
            public CachedValueProvider.Result<List<PsiClass>> compute() {
                SmartList list = new SmartList();
                PsiClass customAutowireConfigurerClass = SpringCommonUtils.findLibraryClass((Module)JamAnnotationTypeUtilImpl.this.myModule, (String)"org.springframework.beans.factory.annotation.CustomAutowireConfigurer");
                if (customAutowireConfigurerClass == null) {
                    return CachedValueProvider.Result.create((Object)list, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
                GlobalSearchScope moduleSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)JamAnnotationTypeUtilImpl.this.myModule);
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)customAutowireConfigurerClass).withInheritors(moduleSearchScope);
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)JamAnnotationTypeUtilImpl.this.myModule.getProject());
                for (SpringModel model : SpringManager.getInstance((Project)JamAnnotationTypeUtilImpl.this.myModule.getProject()).getAllModels(JamAnnotationTypeUtilImpl.this.myModule)) {
                    List beanPointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
                    for (SpringBeanPointer beanPointer : beanPointers) {
                        CommonSpringBean bean = beanPointer.getSpringBean();
                        SpringPropertyDefinition propertyDefinition = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"customQualifierTypes");
                        if (!(propertyDefinition instanceof SpringProperty)) continue;
                        for (String value : SpringPropertyUtils.getListOrSetValues((SpringElementsHolder)((SpringProperty)propertyDefinition))) {
                            PsiClass psiClass;
                            if (StringUtil.isEmptyOrSpaces((String)value) || (psiClass = facade.findClass(value, moduleSearchScope)) == null || !psiClass.isAnnotationType()) continue;
                            list.add(psiClass);
                        }
                    }
                }
                return CachedValueProvider.Result.create((Object)list, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    @NotNull
    public List<String> getUserDefinedCustomComponentAnnotations() {
        List<String> annotations = this.getCustomComponentAnnotations();
        for (String defaultAnno : DEFAULT_SPRING_COMPONENTS) {
            if (defaultAnno.equals("org.springframework.stereotype.Component")) {
                annotations.remove(defaultAnno);
                continue;
            }
            for (PsiClass annoClass : this.getAnnotationTypesWithChildren(defaultAnno)) {
                String qualifiedName = annoClass.getQualifiedName();
                if (qualifiedName == null) continue;
                annotations.remove(qualifiedName);
            }
        }
        List<String> list = annotations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl", "getUserDefinedCustomComponentAnnotations"));
        }
        return list;
    }

    @NotNull
    private List<String> getCustomComponentAnnotations() {
        Collection<PsiClass> classes = this.getAnnotationTypesWithChildren("org.springframework.stereotype.Component");
        List list = ContainerUtil.mapNotNull(classes, (Function)new NullableFunction<PsiClass, String>(){

            public String fun(PsiClass psiClass) {
                return psiClass.getQualifiedName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl", "getCustomComponentAnnotations"));
        }
        return list;
    }

    @NotNull
    public Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull String annotationName) {
        if (annotationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationName", "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl", "getAnnotationTypesWithChildren"));
        }
        Collection<PsiClass> collection = this.getAnnotationTypes(annotationName, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl", "getAnnotationTypesWithChildren"));
        }
        return collection;
    }

    public Collection<PsiClass> getAnnotationTypesWithChildrenIncludingTests(@NotNull String annotationName) {
        if (annotationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationName", "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl", "getAnnotationTypesWithChildrenIncludingTests"));
        }
        return this.getAnnotationTypes(annotationName, true);
    }

    private Collection<PsiClass> getAnnotationTypes(@NotNull String annotationName, boolean inTests) {
        if (annotationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationName", "com/intellij/spring/model/jam/utils/JamAnnotationTypeUtilImpl", "getAnnotationTypes"));
        }
        if (this.myModule.isDisposed()) {
            return Collections.emptyList();
        }
        Key<CachedValue<Collection<PsiClass>>> key = this.cachedKeyMap.get(annotationName + (inTests ? "_INCLUDING_TESTS" : ""));
        return JamCommonUtil.getAnnotationTypesWithChildren((Module)this.myModule, key, (String)annotationName, (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)inTests));
    }
}

