/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.navigation;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import com.intellij.xml.util.PsiElementPointer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GotoSpringBeanProvider
extends GoToSymbolProvider {
    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/navigation/GotoSpringBeanProvider", "addNames"));
        }
        THashSet names = new THashSet();
        for (SpringModel springModel : GotoSpringBeanProvider.getModels(module)) {
            for (SpringBeanPointer pointer : springModel.getAllCommonBeans()) {
                String name = pointer.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                names.add(name);
                for (String alias : pointer.getAliases()) {
                    if (!StringUtil.isNotEmpty((String)alias)) continue;
                    names.add(alias);
                }
            }
        }
        result.addAll((Collection<String>)names);
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/navigation/GotoSpringBeanProvider", "addItems"));
        }
        for (SpringModel springModel : GotoSpringBeanProvider.getModels(module)) {
            List<SpringBeanPointer> pointers = springModel.getDuplicatedNames(name);
            if (pointers.isEmpty()) {
                SpringBeanPointer pointer = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)name);
                if (pointer == null) continue;
                pointers = Collections.singletonList(pointer);
            }
            for (PsiElementPointer psiElementPointer : pointers) {
                PsiElement element = psiElementPointer.getPsiElement();
                if (!(element instanceof NavigationItem)) continue;
                result.add((NavigationItem)element);
            }
        }
    }

    protected boolean acceptModule(Module module) {
        return SpringFacet.getInstance((Module)module) != null;
    }

    private static Set<SpringModel> getModels(Module module) {
        return SpringManager.getInstance((Project)module.getProject()).getAllModelsWithoutDependencies(module);
    }
}

