/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.navigation;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        List properties;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/navigation/SpringGotoRelatedProvider", "getItems"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
        if (tag == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/navigation/SpringGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        DomElement element = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/navigation/SpringGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        if (element instanceof SpringBean) {
            PsiClass psiElement = ((SpringBean)element).getBeanClass();
            if (psiElement != null) {
                UsageTrigger.trigger((String)"spring.GotoRelatedProvider.bean");
                List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem((PsiElement)psiElement));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/navigation/SpringGotoRelatedProvider", "getItems"));
                }
                return list;
            }
        } else if (element instanceof SpringProperty && (properties = (List)((SpringProperty)element).getName().getValue()) != null) {
            UsageTrigger.trigger((String)"spring.GotoRelatedProvider.properties");
            List list = ContainerUtil.map((Collection)properties, (Function)new Function<BeanProperty, GotoRelatedItem>(){

                public GotoRelatedItem fun(BeanProperty beanProperty) {
                    return new GotoRelatedItem((PsiElement)beanProperty.getMethod());
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/navigation/SpringGotoRelatedProvider", "getItems"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/navigation/SpringGotoRelatedProvider", "getItems"));
        }
        return list;
    }
}

