/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.references.SpringQualifierNameReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SpringQualifierNameContributor
extends PsiReferenceContributor {
    private static final Key<PsiElement> PSI_ELEMENT_KEY = Key.create((String)"psiElement");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/references/SpringQualifierNameContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().save(PSI_ELEMENT_KEY)).annotationParam((ElementPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>("customSpringAnno"){

            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/references/SpringQualifierNameContributor$1", "accepts"));
                }
                PsiElement element = (PsiElement)context.get(PSI_ELEMENT_KEY);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null || s.equals("javax.inject.Named")) {
                    return false;
                }
                if (SpringQualifierNameContributor.isQualifierAnnotation(s, "org.springframework.beans.factory.annotation.Qualifier", module)) {
                    return true;
                }
                return SpringQualifierNameContributor.isQualifierAnnotation(s, "javax.inject.Qualifier", module);
            }
        }), "value"), (PsiReferenceProvider)new SpringQualifierNameReferenceProvider());
    }

    private static boolean isQualifierAnnotation(@NotNull String anno, @NotNull String qualifierAnno, @NotNull Module module) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/references/SpringQualifierNameContributor", "isQualifierAnnotation"));
        }
        if (qualifierAnno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierAnno", "com/intellij/spring/references/SpringQualifierNameContributor", "isQualifierAnnotation"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/references/SpringQualifierNameContributor", "isQualifierAnnotation"));
        }
        Collection classes = JamAnnotationTypeUtil.getInstance((Module)module).getAnnotationTypesWithChildren(qualifierAnno);
        for (PsiClass qualifierAnnoClass : classes) {
            if (!anno.equals(qualifierAnnoClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

