/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.SpringDiagramDataModel;
import com.intellij.spring.perspectives.diagrams.SpringDiagramProvider;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.JBColor;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlGraphBuilderFactory;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanPointerGraphPanelContent
implements SpringBeanPointerFinderRecursivePanel.SpringBeanPointerPanelContent {
    private static final Key<DiagramBuilder> GRAPH_BUILDER = Key.create((String)"spring.graph");

    @Override
    public JComponent createComponent(FinderRecursivePanel panel, NullableFactory<CommonSpringModel> factory, SpringBeanPointer pointer) {
        DiagramProvider diagramProvider = this.getProvider(factory, pointer);
        UmlGraphBuilder builder = UmlGraphBuilderFactory.create((Project)panel.getProject(), (DiagramProvider)diagramProvider, null, null);
        panel.getProject().putUserData(GRAPH_BUILDER, (Object)builder);
        Disposer.register((Disposable)panel, (Disposable)builder);
        builder.getView().setFitContentOnResize(true);
        return this.createSimpleBeanGraphView(panel, (DiagramBuilder)builder);
    }

    @Override
    public void update(final FinderRecursivePanel panel) {
        final DiagramBuilder builder = SpringBeanPointerGraphPanelContent.getBuilder(panel);
        if (builder == null) {
            return;
        }
        final DiagramDataModel model = builder.getDataModel();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        DumbService.getInstance((Project)panel.getProject()).runReadActionInSmartMode(new Runnable(){

                            @Override
                            public void run() {
                                model.refreshDataModel();
                            }
                        });
                    }
                }, "Refreshing Bean Graph...", false, panel.getProject());
                builder.updateGraph();
                builder.getView().fitContent();
            }
        });
    }

    @Override
    public Object getData(FinderRecursivePanel panel, @NonNls String dataId) {
        DiagramBuilder builder = SpringBeanPointerGraphPanelContent.getBuilder(panel);
        if (builder == null) {
            return null;
        }
        return UmlFileEditorImpl.getData((String)dataId, (DiagramBuilder)builder);
    }

    @Nullable
    private static DiagramBuilder getBuilder(FinderRecursivePanel panel) {
        Project project = panel.getProject();
        return (DiagramBuilder)project.getUserData(GRAPH_BUILDER);
    }

    private JComponent createSimpleBeanGraphView(FinderRecursivePanel panel, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/spring/toolWindow/panels/SpringBeanPointerGraphPanelContent", "createSimpleBeanGraphView"));
        }
        builder.getPresentationModel().registerActions();
        Graph2DView view = builder.getView();
        GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)panel);
        view.getCanvasComponent().setBackground((Color)JBColor.GRAY);
        GraphSettings settings = GraphSettingsProvider.getInstance((Project)panel.getProject()).getSettings((Graph)builder.getGraph());
        settings.setCurrentLayouter((Layouter)settings.getOrganicLayouter());
        return new UmlGraphZoomableViewport(builder);
    }

    private DiagramProvider getProvider(final NullableFactory<CommonSpringModel> factory, final SpringBeanPointer pointer) {
        return new SpringDiagramProvider(){

            @Override
            public DiagramEdgeCreationPolicy<SpringElementWrapper> getEdgeCreationPolicy() {
                return null;
            }

            @Override
            public DiagramDataModel<SpringElementWrapper> createDataModel(@NotNull Project project, @Nullable SpringElementWrapper element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/toolWindow/panels/SpringBeanPointerGraphPanelContent$2", "createDataModel"));
                }
                return new SpringDiagramDataModel(project, this, null){
                    private DiagramNode<SpringElementWrapper> sourceNode;

                    @Override
                    protected void updateDataModel() {
                        if (!pointer.isValid()) {
                            return;
                        }
                        CommonSpringModel model = (CommonSpringModel)factory.create();
                        if (model == null) {
                            return;
                        }
                        this.sourceNode = this.getOrCreateElement(pointer);
                        if (this.sourceNode != null) {
                            Collection pointers = model.getAllCommonBeans();
                            THashSet pointerSet = new THashSet(pointers);
                            this.processDependencies(model, (Set<SpringBeanPointer>)pointerSet, pointer, this.sourceNode);
                        }
                    }

                    @Override
                    protected boolean isProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
                        if (targetNode == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/spring/toolWindow/panels/SpringBeanPointerGraphPanelContent$2$1", "isProcessed"));
                        }
                        return super.isProcessed(targetNode) || !targetNode.equals(this.sourceNode);
                    }
                };
            }
        };
    }
}

