/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.spring.el.psi.SpringELQualifiedType;
import com.intellij.spring.el.psi.SpringELSelectExpression;
import org.jetbrains.annotations.NotNull;

public class SpringELHighlightingAnnotator
implements Annotator {
    private static final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/el/highlighting/SpringELHighlightingAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/el/highlighting/SpringELHighlightingAnnotator", "annotate"));
        }
        if (element instanceof SpringELQualifiedType) {
            SpringELHighlightingAnnotator.doAnnotate(holder, element, DefaultLanguageHighlighterColors.CLASS_REFERENCE);
        }
        if (element instanceof SpringELSelectExpression) {
            SpringELSelectExpression selectExpression = (SpringELSelectExpression)element;
            ELVariable variable = selectExpression.getField();
            if (variable == null) {
                return;
            }
            PsiReference reference = variable.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolve = reference.resolve();
            if (resolve instanceof PsiMethod) {
                SpringELHighlightingAnnotator.doAnnotate(holder, (PsiElement)variable, DefaultLanguageHighlighterColors.INSTANCE_METHOD);
            } else if (resolve instanceof PsiField) {
                SpringELHighlightingAnnotator.doAnnotate(holder, (PsiElement)variable, DefaultLanguageHighlighterColors.STATIC_FIELD);
            }
        }
    }

    private static void doAnnotate(AnnotationHolder holder, PsiElement element, TextAttributesKey key) {
        String message = DEBUG_MODE ? key.getExternalName() : null;
        holder.createInfoAnnotation(element, message).setTextAttributes(DefaultLanguageHighlighterColors.CLASS_REFERENCE);
    }
}

