/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javascript.flex.css.SwitchToCssDialectQuickFix;
import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptorStub;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorProviderImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.Gray;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.css.JavaFxCSSDialect;
import org.jetbrains.plugins.javaFX.css.JavaFxCssHelper;
import org.jetbrains.plugins.javaFX.css.JavaFxCssPropertyDescriptor;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxStylesheetsIndex;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFxCSSElementDescriptionProvider
extends CssElementDescriptorProviderImpl {
    static final Map<String, Color> ourAdditionalColors = new HashMap<String, Color>(1);

    public boolean isMyContext(@Nullable PsiElement context) {
        return JavaFxCSSElementDescriptionProvider.isJavaFXCSS(context);
    }

    public boolean shouldAskOtherProviders(PsiElement context) {
        return false;
    }

    public static boolean isJavaFXCSS(PsiElement context) {
        return JavaFxCSSElementDescriptionProvider.isJavaFXCSS(context, true);
    }

    public static boolean isJavaFXCSS(PsiElement context, boolean acceptInjected) {
        if (context == null || !context.isValid()) {
            return false;
        }
        final PsiFile file = context.getContainingFile();
        if (file == null) {
            return false;
        }
        Project project = context.getProject();
        if (JavaFxCSSElementDescriptionProvider.isInjected(context, project)) {
            return acceptInjected;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        CssDialect mapping = (CssDialect)CssDialectMappings.getInstance((Project)project).getMapping(virtualFile);
        CssDialect myDialect = JavaFxCSSDialect.getInstance();
        if (mapping == null) {
            boolean hasJavaFxDeclarations = (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)new CachedValueProvider<Boolean>(){

                @Nullable
                public CachedValueProvider.Result<Boolean> compute() {
                    CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, CssDeclaration.class);
                    boolean result = JavaFxCSSElementDescriptionProvider.isJavaFXDeclaration(cssDeclaration) || JavaFxCSSElementDescriptionProvider.isJavaFXDeclaration((CssDeclaration)PsiTreeUtil.findChildOfType((PsiElement)PsiTreeUtil.findChildOfType((PsiElement)file, CssRuleset.class), CssDeclaration.class));
                    return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{file});
                }
            });
            if (hasJavaFxDeclarations || JavaFxStylesheetsIndex.isUsedInFxml(project, file)) {
                return true;
            }
            if (virtualFile != null) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                return module != null && myDialect.isDefault(module);
            }
            return false;
        }
        return mapping == myDialect;
    }

    private static boolean isJavaFXDeclaration(CssDeclaration cssDeclaration) {
        String propertyName;
        return cssDeclaration != null && (propertyName = cssDeclaration.getPropertyName()).startsWith("-fx-");
    }

    private static boolean isInjected(PsiElement context, Project project) {
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(context);
        if (injectionHost != null) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            PsiMethodCallExpression methodCallExpression;
            PsiFile topLevelFile = injectionHost.getContainingFile();
            if (topLevelFile != null && JavaFxFileTypeFactory.isFxml(topLevelFile)) {
                return true;
            }
            if (topLevelFile instanceof PsiClassOwner && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)injectionHost, PsiMethodCallExpression.class)) != null && (psiMethod = methodCallExpression.resolveMethod()) != null && "setStyle".equals(psiMethod.getName()) && (containingClass = psiMethod.getContainingClass()) != null && "javafx.scene.Node".equals(containingClass.getQualifiedName())) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getPropertyDescriptor"));
        }
        return new JavaFxCssPropertyDescriptor(propertyName);
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "findPropertyDescriptors"));
        }
        if ("-fx-font-family".equals(propertyName)) {
            Collection collection = super.findPropertyDescriptors("font-family", context);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "findPropertyDescriptors"));
            }
            return collection;
        }
        List<CssPropertyDescriptor> list = Collections.singletonList(this.getPropertyDescriptor(propertyName, context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "findPropertyDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "findPseudoSelectorDescriptors"));
        }
        List<Object> list = this.isPossiblePseudoSelector(name, null) ? Collections.singletonList(new CssPseudoSelectorDescriptorStub(name)) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "findPseudoSelectorDescriptors"));
        }
        return list;
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "isPossibleSelector"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "isPossibleSelector"));
        }
        return true;
    }

    public boolean isPossiblePseudoSelector(@NotNull String selectorName, @Nullable PsiElement context) {
        if (selectorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorName", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "isPossiblePseudoSelector"));
        }
        return JavaFxCssHelper.getPseudoClasses().contains(selectorName);
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        List list = ContainerUtil.map(JavaFxCssHelper.getPseudoClasses(), (Function)new Function<String, CssPseudoSelectorDescriptor>(){

            public CssPseudoSelectorDescriptor fun(String s) {
                return new CssPseudoSelectorDescriptorStub(s);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getAllPseudoSelectorDescriptors"));
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        List list = ContainerUtil.map(JavaFxCssHelper.getPropertyNames(), (Function)new Function<String, CssPropertyDescriptor>(){

            public CssPropertyDescriptor fun(String s) {
                return new JavaFxCssPropertyDescriptor(s);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getAllPropertyDescriptors"));
        }
        return list;
    }

    @NotNull
    public String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getSimpleSelectors"));
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getSimpleSelectors"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getDeclarationsForSimpleSelector"));
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getDeclarationsForSimpleSelector"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean providesClassicCss() {
        return false;
    }

    public Color getColorByValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getColorByValue"));
        }
        return ourAdditionalColors.get(value);
    }

    public boolean isColorTerm(@NotNull CssTerm term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "isColorTerm"));
        }
        return ourAdditionalColors.get(term.getText()) != null;
    }

    @NotNull
    public LocalQuickFix[] getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getQuickFixesForUnknownProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getQuickFixesForUnknownProperty"));
        }
        if (!isOnTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getQuickFixesForUnknownProperty"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)context);
        if (vFile == null || vFile.getFileType() != CssFileType.INSTANCE) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getQuickFixesForUnknownProperty"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        CssDialect dialect = (CssDialect)CssDialectMappings.getInstance((Project)context.getProject()).getMapping(vFile);
        if (dialect == null || dialect == CssDialect.CLASSIC) {
            List propertyDescriptors;
            Collection<Object> collection = propertyDescriptors = propertyName.startsWith("-fx-") ? this.findPropertyDescriptors(propertyName, context) : Collections.emptyList();
            if (!propertyDescriptors.isEmpty()) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SwitchToCssDialectQuickFix(JavaFxCSSDialect.getInstance())};
                if (localQuickFixArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getQuickFixesForUnknownProperty"));
                }
                return localQuickFixArray;
            }
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/JavaFxCSSElementDescriptionProvider", "getQuickFixesForUnknownProperty"));
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    static {
        ourAdditionalColors.put("transparent", Gray.TRANSPARENT);
    }
}

