/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.grails.compiler;

import groovy.lang.GroovyResourceLoader;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.jetbrains.groovy.compiler.rt.CompilationUnitPatcher;
import org.jetbrains.groovy.grails.compiler.GrailsJUnitPatcher;

public class Grails2_0_JUnitPatcher
extends CompilationUnitPatcher {
    public void patchCompilationUnit(CompilationUnit compilationUnit, GroovyResourceLoader resourceLoader, File[] srcFiles) {
        compilationUnit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                if (Grails2_0_JUnitPatcher.hasTestForAnnotation(classNode)) {
                    source.getAST().addStaticStarImport(null, ClassHelper.make((String)"org.junit.Assert"));
                }
            }
        }, 3);
        compilationUnit.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                if (Grails2_0_JUnitPatcher.hasTestForAnnotation(classNode)) {
                    List methods = classNode.getMethods();
                    for (MethodNode method : methods) {
                        if (!GrailsJUnitPatcher.isTestMethod(method) || Grails2_0_JUnitPatcher.hasAnnotation((AnnotatedNode)method, "org.junit.Test")) continue;
                        if ("java.lang.Object".equals(method.getReturnType().getName())) {
                            if (GrailsJUnitPatcher.isReturnNonVoid(method)) continue;
                            method.setReturnType(ClassHelper.VOID_TYPE);
                        } else if (!ClassHelper.VOID_TYPE.equals((Object)method.getReturnType())) continue;
                        AnnotationNode annotationNode = new AnnotationNode(new ClassNode("org.junit.Test", 9729, ClassHelper.OBJECT_TYPE, new ClassNode[]{ClassHelper.make(Annotation.class)}, MixinNode.EMPTY_ARRAY));
                        annotationNode.setRuntimeRetention(true);
                        annotationNode.setAllowedTargets(4);
                        method.addAnnotation(annotationNode);
                    }
                }
            }
        }, 6);
    }

    public static boolean hasAnnotation(AnnotatedNode node, String annotationName) {
        List annotations = node.getAnnotations();
        for (AnnotationNode annotationNode : annotations) {
            if (!annotationName.equals(annotationNode.getClassNode().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTestForAnnotation(ClassNode classNode) {
        List annotations = classNode.getAnnotations();
        for (AnnotationNode annotationNode : annotations) {
            String annotationName = annotationNode.getClassNode().getName();
            if (!"grails.test.mixin.TestFor".equals(annotationName) && !"TestFor".equals(annotationName) && !"grails.test.mixin.TestMixin".equals(annotationName) && !"TestMixin".equals(annotationName) && !"grails.test.mixin.Mock".equals(annotationName) && !"Mock".equals(annotationName) && !"grails.buildtestdata.mixin.Build".equals(annotationName) && !"Build".equals(annotationName)) continue;
            return true;
        }
        return false;
    }
}

