/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.inspections.DefineInCommentIntentionBase;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileViewProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefineImplicitVariableIntention
extends DefineInCommentIntentionBase {
    private final boolean myAddFileReference;

    protected DefineImplicitVariableIntention(String text, boolean addFileReference) {
        super(text);
        this.myAddFileReference = addFileReference;
    }

    @NotNull
    public String getFamilyName() {
        String string = FreeMarkerBundle.message("add.implicit.variable.fix.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/DefineImplicitVariableIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineImplicitVariableIntention", "isAvailable"));
        }
        if (!(file.getViewProvider() instanceof FtlFileViewProvider)) {
            return false;
        }
        FtlQualifiedReference expr = DefineImplicitVariableIntention.findQualifiedReference(editor, file);
        if (expr == null || expr.resolve() != null) {
            return false;
        }
        if (FtlPsiUtil.splitVarNames(expr) == null) {
            return false;
        }
        PsiElement parent = expr.getExpressionParent();
        if (parent instanceof FtlNameValuePair && ((FtlNameValuePair)parent).getNameElement() == expr.getElement()) {
            return false;
        }
        if (parent instanceof FtlMacro) {
            return false;
        }
        if (!this.isAvailableOnCall(expr)) {
            return false;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        return module != null;
    }

    protected boolean isAvailableOnCall(FtlQualifiedReference expr) {
        return !(expr.getExpressionParent() instanceof FtlMethodCallExpression);
    }

    private static String combineVarNames(String[] names) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            boolean isId = FtlPsiUtil.isValidVariableName(name);
            if (i > 0 && isId) {
                builder.append('.');
            }
            if (i == 0 && !isId) {
                builder.append(".vars");
            }
            if (isId) {
                builder.append(name);
                continue;
            }
            builder.append("['").append(name).append("']");
        }
        return builder.toString();
    }

    @Override
    protected void fillTemplate(Template template, PsiFile targetFile, PsiFile sourceFile, FtlDirectiveStyle style, Editor editor) throws IncorrectOperationException {
        List<String> allNames;
        Expression typeExpression;
        FtlQualifiedReference reference = DefineImplicitVariableIntention.findQualifiedReference(editor, sourceFile);
        if (reference != null) {
            typeExpression = this.createTypeExpression(reference);
            allNames = this.getNameVariants(reference);
        } else {
            FtlParameterDeclaration param = (FtlParameterDeclaration)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)sourceFile, (int)DefineImplicitVariableIntention.getAdjustedCaretOffset(editor), FtlParameterDeclaration.class, (boolean)false);
            assert (param != null);
            allNames = Collections.singletonList(param.getName());
            typeExpression = DefineImplicitVariableIntention.completeSmart();
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)targetFile.getProject());
        Document document = documentManager.getDocument(targetFile);
        assert (document != null);
        String fileRef = "";
        if (this.myAddFileReference) {
            String mockVar = "<#-- @ftlvariable name=\"a\" type=\"b\" file=\"abc\" -->";
            document.insertString(0, (CharSequence)"<#-- @ftlvariable name=\"a\" type=\"b\" file=\"abc\" -->");
            documentManager.commitDocument(document);
            FtlReferenceContributor.getFileReferences(targetFile.findElementAt(1))[0].bindToElement((PsiElement)sourceFile);
            String newText = targetFile.findElementAt(1).getText();
            Matcher matcher = FtlFile.VAR_DECL_PATTERN.matcher(newText);
            assert (matcher.matches());
            fileRef = matcher.group(3);
            PostprocessReformattingAspect.getInstance((Project)targetFile.getProject()).doPostponedFormatting();
            document.deleteString(0, newText.length());
            documentManager.commitDocument(document);
        }
        final String name = allNames.get(0);
        template.addTextSegment(style.getDirectiveStartChar() + "#-- @ftlvariable name=\"");
        Expression nameExpression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return allNames.size() == 1 ? new TextResult(name) : null;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return allNames.size() == 1 ? new TextResult(name) : null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return (LookupElement[])ContainerUtil.map2Array((Collection)allNames, LookupElement.class, (Function)new Function<String, LookupElement>(){

                    public LookupElement fun(String s) {
                        return LookupElementBuilder.create((String)s);
                    }
                });
            }
        };
        template.addVariable("NAME", nameExpression, nameExpression, false);
        template.addTextSegment("\" type=\"");
        template.addVariable("TYPE", typeExpression, typeExpression, true);
        template.addTextSegment("\"" + fileRef + " --" + style.getDirectiveEndChar() + "\n");
        template.addEndVariable();
    }

    protected Expression createTypeExpression(FtlQualifiedReference reference) {
        return DefineImplicitVariableIntention.completeSmart();
    }

    private static MacroCallNode completeSmart() {
        return new MacroCallNode((Macro)new CompleteSmartMacro());
    }

    protected List<String> getNameVariants(FtlQualifiedReference reference) {
        String[] strings;
        SmartList allNames = new SmartList();
        for (FtlQualifiedReference each = reference; each != null && !each.isCall() && (strings = FtlPsiUtil.splitVarNames(each)) != null; each = each.getParentReference()) {
            allNames.add(DefineImplicitVariableIntention.combineVarNames(strings));
        }
        return allNames;
    }

    public static class LocalExternal
    extends DefineImplicitVariableIntention {
        public LocalExternal() {
            super(FreeMarkerBundle.message("add.implicit.variable.fix.name.external", new Object[0]), true);
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineImplicitVariableIntention$LocalExternal", "invoke"));
            }
            this.chooseTargetFile(file, editor);
        }
    }

    public static class ModuleWide
    extends DefineImplicitVariableIntention {
        public ModuleWide() {
            super(FreeMarkerBundle.message("add.implicit.variable.fix.name.module.wide", new Object[0]), false);
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineImplicitVariableIntention$ModuleWide", "invoke"));
            }
            this.chooseTargetFile(file, editor);
        }
    }

    public static class Local
    extends DefineImplicitVariableIntention {
        public Local() {
            super(FreeMarkerBundle.message("add.implicit.variable.fix.name.local", new Object[0]), false);
        }

        @Nullable
        private static FtlParameterDeclaration findParameterDeclaration(@Nullable PsiElement leaf) {
            PsiElement context = leaf == null ? null : leaf.getContext();
            PsiElement grand = context != null ? context.getContext() : null;
            return grand instanceof FtlParameterDeclaration ? (FtlParameterDeclaration)grand : null;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineImplicitVariableIntention$Local", "isAvailable"));
            }
            PsiElement leaf = file.findElementAt(Local.getAdjustedCaretOffset(editor));
            FtlParameterDeclaration param = Local.findParameterDeclaration(leaf);
            if (param != null) {
                assert (leaf != null);
                return leaf.getParent() == param.getNameElement() && param.getCommentType() == null && param.getScopeDirective() != null && param.getScopeDirective().getStartTagEndElement() != null;
            }
            return super.isAvailable(project, editor, file);
        }

        @Override
        protected int calcInsertionIndex(PsiFile psiFile, Editor editor, FtlDirectiveStyle style) {
            PsiElement leaf = psiFile.findElementAt(Local.getAdjustedCaretOffset(editor));
            FtlParameterDeclaration param = Local.findParameterDeclaration(leaf);
            if (param != null) {
                FtlSignatureDirective directive = param.getScopeDirective();
                PsiElement element = directive.getStartTagEndElement();
                assert (element != null);
                int start = directive.getTextRange().getStartOffset();
                int end = element.getTextRange().getEndOffset();
                int nextLine = editor.logicalPositionToOffset(new LogicalPosition(editor.offsetToLogicalPosition((int)end).line + 1, editor.offsetToLogicalPosition((int)start).column));
                if (StringUtil.isEmptyOrSpaces((String)editor.getDocument().getCharsSequence().subSequence(end, nextLine).toString())) {
                    return nextLine;
                }
                return end;
            }
            return super.calcInsertionIndex(psiFile, editor, style);
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineImplicitVariableIntention$Local", "invoke"));
            }
            this.addDeclaration(file, editor, file);
        }
    }
}

