/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.AbstractFtlExpression;
import com.intellij.freemarker.psi.FtlBinaryExpression;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlHashLiteral;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlUnaryExpression;
import com.intellij.freemarker.psi.directives.FtlAssignDirective;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlIfDirective;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlVisitDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlNamespaceType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class FtlTypesInspection
extends FtlSuppressableInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlTypesInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                FtlType type;
                FtlExpression condition;
                FtlDirective directive;
                FtlType type2;
                AbstractFtlExpression expression;
                FtlExpression expression2;
                if (element instanceof FtlInterpolation) {
                    FtlInterpolation interpolation = (FtlInterpolation)element;
                    expression2 = interpolation.getExpression();
                    if (expression2 == null) {
                        return;
                    }
                    FtlType expressionType = expression2.getType();
                    if (expressionType == null) {
                        return;
                    }
                    if (interpolation.isNumeric()) {
                        FtlTypesInspection.checkNumericType(interpolation.getFirstChild(), holder, expressionType);
                    } else {
                        FtlPsiType type3 = FtlPsiUtil.asInstanceOf(expressionType, FtlPsiType.class);
                        if (type3 == null || expression2 instanceof FtlHashLiteral || PsiType.BOOLEAN.equals((Object)type3.getPsiType())) {
                            holder.registerProblem(interpolation.getFirstChild(), FreeMarkerBundle.message("expression.should.have.scalar.type", expressionType.getPresentableText()), new LocalQuickFix[0]);
                        }
                    }
                }
                if (element instanceof FtlBinaryExpression) {
                    expression = (FtlBinaryExpression)element;
                    if (((FtlBinaryExpression)expression).getOperationSign() == FtlElementTypes.ASTERISK) {
                        FtlExpression left = ((FtlBinaryExpression)expression).getLeftOperand();
                        if (left != null && FtlTypesInspection.checkNumericType(left, holder, left.getType())) {
                            return;
                        }
                        FtlExpression right = ((FtlBinaryExpression)expression).getRightOperand();
                        if (right != null) {
                            FtlTypesInspection.checkNumericType(right, holder, right.getType());
                        }
                    }
                    return;
                }
                if (element instanceof FtlUnaryExpression) {
                    expression = (FtlUnaryExpression)element;
                    FtlExpression operand = ((FtlUnaryExpression)expression).getOperand();
                    if (operand == null) {
                        return;
                    }
                    type2 = operand.getType();
                    if (type2 == null) {
                        return;
                    }
                    FtlTokenType operation = ((FtlUnaryExpression)expression).getOperation();
                    if (operation == FtlElementTypes.EXCLAM) {
                        FtlTypesInspection.checkBooleanType(operand, type2, holder);
                    } else if (operation != FtlElementTypes.EXCLAM) {
                        FtlTypesInspection.checkNumericType(operand, holder, type2);
                    }
                }
                if (element instanceof FtlListDirective) {
                    directive = (FtlListDirective)element;
                    expression2 = ((FtlListDirective)directive).getListExpression();
                    if (expression2 == null) {
                        return;
                    }
                    type2 = expression2.getType();
                    if (type2 == null) {
                        return;
                    }
                    if (!FtlListDirective.isCollectionType(type2)) {
                        holder.registerProblem((PsiElement)expression2, FreeMarkerBundle.message("expression.should.have.array.or.collection.type", type2.getPresentableText()), new LocalQuickFix[0]);
                    }
                }
                if (element instanceof FtlAssignDirective) {
                    FtlTypesInspection.checkTypeClass(((FtlAssignDirective)element).getNamespaceExpression(), holder, FtlNamespaceType.class, "expression.should.have.namespace.type");
                }
                if (element instanceof FtlVisitDirective) {
                    directive = (FtlVisitDirective)element;
                    FtlTypesInspection.checkTypeClass(((FtlVisitDirective)directive).getNodeExpression(), holder, FtlNodeType.class, "expression.should.have.node.type");
                    FtlTypesInspection.checkTypeClass(((FtlVisitDirective)directive).getNamespaceExpression(), holder, FtlNamespaceType.class, "expression.should.have.namespace.type");
                }
                if (element instanceof FtlIfDirective && (condition = ((FtlIfDirective)element).getCondition()) != null && (type = condition.getType()) != null) {
                    FtlTypesInspection.checkBooleanType(condition, type, holder);
                }
                if (element instanceof FtlMacro) {
                    FtlExpression[] references;
                    for (FtlExpression reference : references = ((FtlMacro)element).getAllMacroReferences()) {
                        FtlCallableType callableType;
                        FtlType type4 = reference.getType();
                        if (type4 == null || (callableType = FtlPsiUtil.asInstanceOf(type4, FtlCallableType.class)) != null && callableType.isMacro()) continue;
                        holder.registerProblem((PsiElement)reference, FreeMarkerBundle.message("expression.should.have.macro.type", type4.getPresentableText()), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlTypesInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static void checkBooleanType(FtlExpression expression, FtlType type, ProblemsHolder holder) {
        FtlPsiType fpType = type.asInstanceOf(FtlPsiType.class);
        if (fpType == null || !PsiType.BOOLEAN.isAssignableFrom(fpType.getPsiType())) {
            holder.registerProblem((PsiElement)expression, FreeMarkerBundle.message("expression.should.have.boolean.type", fpType == null ? "null" : fpType.getPresentableText()), new LocalQuickFix[0]);
        }
    }

    private static boolean checkNumericType(@NotNull PsiElement element, ProblemsHolder holder, FtlType type) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlTypesInspection", "checkNumericType"));
        }
        if (type != null && !FtlPsiUtil.isNumeric(type, element)) {
            holder.registerProblem(element, FreeMarkerBundle.message("expression.should.have.numeric.type", type.getPresentableText()), new LocalQuickFix[0]);
            return true;
        }
        return false;
    }

    private static void checkTypeClass(FtlExpression expression, ProblemsHolder holder, Class<? extends FtlType> aClass, @PropertyKey(resourceBundle="messages.FreeMarkerBundle") String key) {
        FtlType type;
        if (expression != null && (type = expression.getType()) != null && type.asInstanceOf(aClass) == null) {
            holder.registerProblem((PsiElement)expression, FreeMarkerBundle.message(key, type.getPresentableText()), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlTypesInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlTypesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.types.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlTypesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("FtlTypesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlTypesInspection", "getShortName"));
        }
        return "FtlTypesInspection";
    }
}

