/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlReferenceExpression
extends FtlCompositeElement
implements FtlReferenceQualifier {
    private final FtlQualifiedReference myReference;

    private PsiElement getReferenceNameElement() {
        return this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
    }

    protected FtlReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/freemarker/psi/FtlReferenceExpression", "<init>"));
        }
        super(node);
        this.myReference = new FtlQualifiedReference(this){

            public TextRange getRangeInElement() {
                PsiElement element = FtlReferenceExpression.this.getReferenceNameElement();
                if (element == null || FtlReferenceExpression.this.isSpecialVariable()) {
                    return TextRange.from((int)0, (int)FtlReferenceExpression.this.getTextLength());
                }
                return TextRange.from((int)element.getStartOffsetInParent(), (int)element.getTextLength());
            }

            @Override
            @Nullable
            public String getReferenceName() {
                PsiElement element = FtlReferenceExpression.this.getReferenceNameElement();
                if (element == null) {
                    return null;
                }
                String s = element.getText().trim();
                return FtlReferenceExpression.this.isSpecialVariable() ? "." + s : s;
            }

            @Override
            public FtlReferenceQualifier getReferenceQualifier() {
                return (FtlReferenceQualifier)FtlReferenceExpression.this.findChildByClass(FtlReferenceQualifier.class);
            }

            @Override
            public PsiElement doHandleElementRename(String newElementName) throws IncorrectOperationException {
                PsiElement newReferenceName = this.parseReference(newElementName).getReferenceNameElement();
                FtlReferenceExpression.this.getNode().replaceChild(FtlReferenceExpression.this.getReferenceNameElement().getNode(), newReferenceName.getNode());
                return FtlReferenceExpression.this;
            }

            @NotNull
            private FtlReferenceExpression parseReference(String newText) {
                FtlReferenceExpression ftlReferenceExpression = (FtlReferenceExpression)FtlPsiUtil.parseFtlExpression(newText, FtlReferenceExpression.this.getProject());
                if (ftlReferenceExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlReferenceExpression$1", "parseReference"));
                }
                return ftlReferenceExpression;
            }
        };
    }

    @NotNull
    public FtlQualifiedReference getReference() {
        FtlQualifiedReference ftlQualifiedReference = this.myReference;
        if (ftlQualifiedReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlReferenceExpression", "getReference"));
        }
        return ftlQualifiedReference;
    }

    private boolean isSpecialVariable() {
        return this.getFirstChild().getNode().getElementType() == FtlElementTypes.DOT;
    }

    @Override
    @Nullable
    public FtlType getType() {
        return (FtlType)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, (Computable)new Computable<FtlType>(){

            public FtlType compute() {
                return FtlReferenceExpression.this.myReference.getType();
            }
        });
    }

    @Override
    public Object getConstantValue() {
        return null;
    }

    @Override
    public FtlCallableType[] getCallableCandidates() {
        return this.myReference.getCallableCandidates();
    }
}

