/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.psi.FtlDateType;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.freemarker.psi.variables.FtlLightVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlSpecialVariableType;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.freemarker.psi.variables.GlobalVariablesProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FtlDefaultGlobalVariablesProvider
extends FtlGlobalVariableProvider {
    @Override
    @NotNull
    public List<? extends FtlVariable> getGlobalVariables(final FtlFile file) {
        FtlPsiType stringType = FtlPsiType.wrap((PsiType)PsiType.getJavaLangString((PsiManager)file.getManager(), (GlobalSearchScope)file.getResolveScope()));
        ArrayList list = ContainerUtil.newArrayList();
        list.add(new FtlLightVariable(".vars", (PsiElement)file, new FtlSpecialVariableType(){

            @Override
            public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull PsiElement place, ResolveState state) {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/variables/FtlDefaultGlobalVariablesProvider$1", "processDeclarations"));
                }
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/variables/FtlDefaultGlobalVariablesProvider$1", "processDeclarations"));
                }
                return PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)place, null, (ResolveState)state);
            }
        }));
        list.add(new FtlLightVariable(".namespace", (PsiElement)file, new FtlTemplateType(file)));
        list.add(new FtlLightVariable(".main", (PsiElement)file, new FtlTemplateType(file)));
        list.add(new FtlLightVariable(".globals", (PsiElement)file, FtlDefaultGlobalVariablesProvider.getVariableHolderType(FtlAssignmentType.GLOBAL)));
        list.add(new FtlLightVariable(".dataModel", (PsiElement)file, FtlDefaultGlobalVariablesProvider.getVariableHolderType(FtlAssignmentType.ASSIGN)));
        list.add(new FtlLightVariable(".node", (PsiElement)file, FtlNodeType.INSTANCE));
        list.add(new FtlLightVariable(".now", (PsiElement)file, FtlDateType.INSTANCE));
        list.add(new FtlLightVariable(".currentNode", (PsiElement)file, FtlNodeType.INSTANCE));
        list.add(new FtlLightVariable(".locale", (PsiElement)file, stringType));
        list.add(new FtlLightVariable(".lang", (PsiElement)file, stringType));
        list.add(new FtlLightVariable(".outputEncoding", (PsiElement)file, stringType));
        list.add(new FtlLightVariable(".templateName", (PsiElement)file, stringType));
        list.add(new FtlLightVariable(".urlEscapingCharset", (PsiElement)file, stringType));
        list.add(new FtlLightVariable(".version", (PsiElement)file, stringType));
        list.add(new FtlLightVariable(".currentTemplateName", (PsiElement)file, stringType));
        list.add(new FtlLightVariable(".mainTemplateName", (PsiElement)file, stringType));
        if (FtlPsiUtil.isUsingCamelCase(file)) {
            ArrayList arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlDefaultGlobalVariablesProvider", "getGlobalVariables"));
            }
            return arrayList;
        }
        List list2 = ContainerUtil.map((Collection)list, (Function)new Function<FtlLightVariable, FtlVariable>(){

            public FtlVariable fun(FtlLightVariable variable) {
                String snake = FtlPsiUtil.camelToSnakeCase(variable.getName());
                return snake == null ? variable : new FtlLightVariable(snake, (PsiElement)file, variable.getType());
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/variables/FtlDefaultGlobalVariablesProvider", "getGlobalVariables"));
        }
        return list2;
    }

    private static FtlSpecialVariableType getVariableHolderType(final FtlAssignmentType assignmentType) {
        return new FtlSpecialVariableType(){

            @Override
            public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull PsiElement place, ResolveState state) {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/variables/FtlDefaultGlobalVariablesProvider$3", "processDeclarations"));
                }
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/variables/FtlDefaultGlobalVariablesProvider$3", "processDeclarations"));
                }
                return PsiScopesUtil.treeWalkUp((PsiScopeProcessor)new GlobalVariablesProcessor(processor), (PsiElement)place, null, (ResolveState)FtlAssignmentType.allowAssignments(state, assignmentType));
            }
        };
    }
}

