/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.SpringDataBundle;
import com.intellij.spring.data.util.QueryTree;
import com.intellij.spring.data.util.SpringDataUtil;
import com.intellij.spring.data.util.nodes.PropertyNode;
import com.intellij.spring.data.util.nodes.PropertyParametersType;
import com.intellij.spring.data.util.nodes.QueryNode;
import com.intellij.spring.data.util.nodes.SelectPropertyNode;
import com.intellij.spring.model.highlighting.jam.AbstractSpringJavaConfigInspection;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataJpaMethodInconsistencyInspection
extends AbstractSpringJavaConfigInspection {
    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFile", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkJavaFile"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkJavaFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkJavaFile"));
        }
        if (!SpringDataUtil.hasSpringDataSupport(module.getProject())) {
            return;
        }
        super.checkJavaFile(javaFile, holder, isOnTheFly, module);
    }

    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkClass"));
        }
        if (!SpringDataUtil.isRepository(aClass)) {
            return;
        }
        Pair<PsiClass, ? extends PsiType> typePair = SpringDataUtil.substituteRepositoryTypes(aClass);
        if (typePair != null) {
            for (PsiMethod psiMethod : aClass.getMethods()) {
                if (!SpringDataUtil.isQueryMethod(psiMethod)) continue;
                this.checkRepositoryMethod(holder, psiMethod, module, typePair);
            }
        }
    }

    private void checkRepositoryMethod(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkRepositoryMethod"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkRepositoryMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkRepositoryMethod"));
        }
        if (typePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePair", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkRepositoryMethod"));
        }
        PersistentEntity persistenceEntity = SpringDataUtil.getMappedPersistenceEntity(typePair);
        if (persistenceEntity != null) {
            SpringDataJpaMethodInconsistencyInspection.checkMethodReturnType(psiMethod, (PsiClass)typePair.getFirst(), holder);
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, Collections.singleton("org.springframework.data.jpa.repository.Query")) && !SpringDataJpaMethodInconsistencyInspection.checkMethodName(holder, psiMethod, module, typePair)) {
                SpringDataJpaMethodInconsistencyInspection.checkParameters(holder, psiMethod, module, persistenceEntity);
            }
        }
    }

    private static void checkParameters(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, @NotNull Module module, PersistentEntity persistenceEntity) {
        QueryNode[] queryNodes;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkParameters"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkParameters"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkParameters"));
        }
        LinkedHashSet<SelectPropertyNode> selects = new LinkedHashSet<SelectPropertyNode>();
        for (QueryNode queryNode : queryNodes = new QueryTree(psiMethod.getName()).toLeavesArray()) {
            if (!(queryNode instanceof SelectPropertyNode)) continue;
            selects.add((SelectPropertyNode)queryNode);
        }
        if (SpringDataJpaMethodInconsistencyInspection.checkParametersInconsistency(psiMethod, selects, holder, persistenceEntity)) {
            // empty if block
        }
    }

    private static boolean checkParametersInconsistency(@NotNull PsiMethod psiMethod, @NotNull Set<SelectPropertyNode> selects, @NotNull ProblemsHolder holder, @NotNull PersistentEntity persistenceEntity) {
        PsiIdentifier identifier;
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkParametersInconsistency"));
        }
        if (selects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selects", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkParametersInconsistency"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkParametersInconsistency"));
        }
        if (persistenceEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceEntity", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkParametersInconsistency"));
        }
        List<PsiType> requiredParameterTypes = SpringDataJpaMethodInconsistencyInspection.getRequiredParameterTypes(selects, persistenceEntity, psiMethod.getProject());
        if (!SpringDataJpaMethodInconsistencyInspection.areAssignableTypes(psiMethod, requiredParameterTypes) && (identifier = psiMethod.getNameIdentifier()) != null) {
            String text = SpringDataJpaMethodInconsistencyInspection.getRequiredParametersTypesToString(requiredParameterTypes, psiMethod.getParameterList());
            holder.registerProblem((PsiElement)identifier, SpringDataBundle.message("required.parameters", text), SpringDataJpaMethodInconsistencyInspection.getQuickFixes(psiMethod, selects, persistenceEntity));
        }
        return false;
    }

    private static LocalQuickFix[] getQuickFixes(PsiMethod psiMethod, Set<SelectPropertyNode> requiredParameterTypes, PersistentEntity persistenceEntity) {
        return new LocalQuickFix[]{SpringDataJpaMethodInconsistencyInspection.createMethodParametersFix(psiMethod, requiredParameterTypes, persistenceEntity)};
    }

    private static LocalQuickFix createMethodParametersFix(PsiMethod psiMethod, Set<SelectPropertyNode> nodes, PersistentEntity persistenceEntity) {
        return new ReplaceAllParametersQuickFix(nodes, psiMethod, persistenceEntity);
    }

    private static void removeOldParameters(PsiMethod psiMethod) {
        PsiParameter[] parameters;
        for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
            parameter.delete();
        }
    }

    private static PsiClassType getObjectClassType(Project project) {
        return PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    private static boolean areAssignableTypes(@NotNull PsiMethod psiMethod, @NotNull List<PsiType> requiredParameterTypes) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "areAssignableTypes"));
        }
        if (requiredParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredParameterTypes", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "areAssignableTypes"));
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        if (parameters.length == 0 && requiredParameterTypes.size() == 0) {
            return true;
        }
        int requiredParameterIndex = 0;
        for (int i = 0; i < parameters.length; ++i) {
            PsiType parameterType = parameters[i].getType();
            if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.domain.Pageable") || InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.domain.Sort")) continue;
            if (requiredParameterIndex >= requiredParameterTypes.size()) {
                return false;
            }
            PsiType requiredType = requiredParameterTypes.get(requiredParameterIndex);
            if (requiredType == null) continue;
            if (!parameterType.isAssignableFrom(requiredType)) {
                return false;
            }
            ++requiredParameterIndex;
        }
        return requiredParameterIndex == requiredParameterTypes.size();
    }

    private static String getRequiredParametersTypesToString(List<PsiType> requiredParameterTypes, PsiParameterList parameterList) {
        String[] types = new String[requiredParameterTypes.size()];
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < requiredParameterTypes.size(); ++i) {
            boolean boldType = true;
            PsiType requiredType = requiredParameterTypes.get(i);
            if (i < parameters.length) {
                PsiType parameterType = parameters[i].getType();
                if (requiredType != null && parameterType.isAssignableFrom(requiredType)) {
                    boldType = false;
                }
            }
            String text = requiredType == null ? SpringDataJpaMethodInconsistencyInspection.getUnresolvedTypeText() : XmlStringUtil.escapeString((String)requiredType.getPresentableText());
            types[i] = boldType ? "<b>" + text + "</b>" : text;
        }
        return StringUtil.join((String[])types, (String)", ");
    }

    private static String getUnresolvedTypeText() {
        return "? extends Object";
    }

    private static List<PsiType> getRequiredParameterTypes(Set<SelectPropertyNode> selects, PersistentEntity persistenceEntity, Project project) {
        LinkedList<PsiType> psiTypes = new LinkedList<PsiType>();
        for (SelectPropertyNode select : selects) {
            PsiType psiType = SpringDataUtil.resolveJpaProperty(select.getPropertyName(), persistenceEntity);
            if (SpringDataJpaMethodInconsistencyInspection.isCollectionTypeRequired(select)) {
                psiType = SpringDataJpaMethodInconsistencyInspection.createTypedCollection(project, psiType);
            }
            int argumentsNumber = select.getType().getArgumentsNumber();
            for (int i = 0; i < argumentsNumber; ++i) {
                psiTypes.add(psiType);
            }
        }
        return psiTypes;
    }

    private static PsiType createTypedCollection(Project project, PsiType psiType) {
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(SpringDataJpaMethodInconsistencyInspection.getCollectionClass(project), psiType);
    }

    private static boolean isCollectionTypeRequired(SelectPropertyNode select) {
        return select.getType() == PropertyParametersType.IN || select.getType() == PropertyParametersType.NOT_IN;
    }

    @Nullable
    private static PsiClass getCollectionClass(Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass("java.util.Collection", GlobalSearchScope.allScope((Project)project));
    }

    private static boolean checkMethodName(@NotNull ProblemsHolder holder, @NotNull PsiMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkMethodName"));
        }
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkMethodName"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkMethodName"));
        }
        if (typePair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typePair", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkMethodName"));
        }
        boolean hasErrors = false;
        QueryTree queryTree = new QueryTree(psiMethod.getName());
        PersistentEntity persistenceEntity = SpringDataUtil.getMappedPersistenceEntity(typePair);
        if (persistenceEntity != null) {
            for (Pair<PropertyNode, Integer> pair : SpringDataJpaMethodInconsistencyInspection.getPropertyNodes(queryTree)) {
                PropertyNode node = (PropertyNode)pair.first;
                String propertyName = node.getPropertyName();
                if (SpringDataUtil.resolveJpaProperty(propertyName, (PsiClass)typePair.first) != null) continue;
                Integer startOffset = (Integer)pair.getSecond();
                Integer firstUnresolvedOffset = SpringDataJpaMethodInconsistencyInspection.getFirstUnresolvedOffset(propertyName, (PsiClass)typePair.first, startOffset);
                PsiIdentifier psiIdentifier = psiMethod.getNameIdentifier();
                if (psiIdentifier == null) continue;
                holder.registerProblem((PsiElement)psiIdentifier, TextRange.create((int)firstUnresolvedOffset, (int)(startOffset + propertyName.length())), SpringDataBundle.message("cannot.resolve.property", propertyName.substring(firstUnresolvedOffset - startOffset, propertyName.length())), new LocalQuickFix[0]);
                hasErrors = true;
            }
        }
        return hasErrors;
    }

    private static int getFirstUnresolvedOffset(@NotNull String expression, @Nullable PsiClass psiClass, int startOffset) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "getFirstUnresolvedOffset"));
        }
        if (psiClass != null) {
            PsiField[] allFields;
            for (PsiField field : allFields = psiClass.getAllFields()) {
                PsiType type;
                String propertyExpression;
                if (!expression.startsWith(field.getName()) || StringUtil.isEmptyOrSpaces((String)(propertyExpression = SpringDataUtil.getChildPropertyExpression(expression, field.getName()))) || !StringUtil.isCapitalized((String)propertyExpression) || !((type = field.getType()) instanceof PsiClassType)) continue;
                return SpringDataJpaMethodInconsistencyInspection.getFirstUnresolvedOffset(StringUtil.decapitalize((String)propertyExpression), ((PsiClassType)type).resolve(), startOffset + expression.indexOf(propertyExpression));
            }
        }
        return startOffset;
    }

    private static Set<Pair<PropertyNode, Integer>> getPropertyNodes(QueryTree queryTree) {
        HashSet properties = new HashSet();
        int offset = 0;
        for (QueryNode queryNode : queryTree.toLeavesArray()) {
            if (queryNode instanceof PropertyNode) {
                properties.add(Pair.create((Object)((PropertyNode)queryNode), (Object)offset));
            }
            offset += queryNode.getExpression().length();
        }
        return properties;
    }

    private static void checkMethodReturnType(@NotNull PsiMethod psiMethod, @NotNull PsiClass domainType, @NotNull ProblemsHolder holder) {
        PsiIdentifier identifier;
        PsiType returnType;
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkMethodReturnType"));
        }
        if (domainType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainType", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkMethodReturnType"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "checkMethodReturnType"));
        }
        PsiClassType type = PsiTypesUtil.getClassType((PsiClass)domainType);
        if (!SpringDataJpaMethodInconsistencyInspection.isAssignableType((PsiType)type, returnType = psiMethod.getReturnType()) && (identifier = psiMethod.getNameIdentifier()) != null) {
            holder.registerProblem((PsiElement)identifier, SpringDataBundle.message("incorrect.method.return.type", domainType.getQualifiedName()), new LocalQuickFix[0]);
        }
    }

    public static boolean isAssignableType(@Nullable PsiType type, @Nullable PsiType returnType) {
        if (type == null || returnType == null) {
            return false;
        }
        if (returnType.isAssignableFrom(type)) {
            return true;
        }
        PsiType genericType = PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)false);
        genericType = genericType != null ? genericType : PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"java.util.Optional", (int)0, (boolean)false);
        genericType = genericType != null ? genericType : PsiUtil.substituteTypeParameter((PsiType)returnType, (String)"com.google.common.base.Optional", (int)0, (boolean)false);
        return genericType != null && genericType.isAssignableFrom(type);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringDataJpaMethodInconsistencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection", "getShortName"));
        }
        return "SpringDataJpaMethodInconsistencyInspection";
    }

    private static class ReplaceAllParametersQuickFix
    implements LocalQuickFix {
        private final Set<SelectPropertyNode> myNodes;
        private final PsiMethod myPsiMethod;
        private final Map<String, PsiType> myParamsMap;

        public ReplaceAllParametersQuickFix(Set<SelectPropertyNode> nodes, PsiMethod psiMethod, PersistentEntity persistenceEntity) {
            this.myNodes = nodes;
            this.myPsiMethod = psiMethod;
            this.myParamsMap = this.createParamMap(this.myNodes, this.myPsiMethod.getProject(), persistenceEntity, InheritanceUtil.isInheritor((PsiType)this.myPsiMethod.getReturnType(), (String)"org.springframework.data.domain.Page"));
        }

        @NotNull
        public String getName() {
            String[] types = new String[this.myParamsMap.size()];
            int i = 0;
            for (String paramName : this.myParamsMap.keySet()) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.myParamsMap.get(paramName).getPresentableText());
                sb.append(" ");
                sb.append(paramName);
                types[i++] = sb.toString();
            }
            String string = SpringDataBundle.message("create.required.parameters", StringUtil.join((String[])types, (String)", "));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection$ReplaceAllParametersQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringDataBundle.message("create.required.parameters.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection$ReplaceAllParametersQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection$ReplaceAllParametersQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection$ReplaceAllParametersQuickFix", "applyFix"));
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            SpringDataJpaMethodInconsistencyInspection.removeOldParameters(this.myPsiMethod);
            for (Map.Entry<String, PsiType> entry : this.myParamsMap.entrySet()) {
                this.myPsiMethod.getParameterList().add((PsiElement)factory.createParameter(entry.getKey(), entry.getValue()));
            }
        }

        private Map<String, PsiType> createParamMap(Set<SelectPropertyNode> nodes, Project project, PersistentEntity persistenceEntity, boolean addPageable) {
            LinkedHashMap<String, PsiType> paramMap = new LinkedHashMap<String, PsiType>();
            PsiClassType objectClassType = SpringDataJpaMethodInconsistencyInspection.getObjectClassType(project);
            for (SelectPropertyNode node : nodes) {
                String propertyName = node.getPropertyName();
                PsiType psiType = SpringDataUtil.resolveJpaProperty(propertyName, persistenceEntity);
                if (SpringDataJpaMethodInconsistencyInspection.isCollectionTypeRequired(node)) {
                    psiType = SpringDataJpaMethodInconsistencyInspection.createTypedCollection(project, psiType);
                }
                int argumentsNumber = node.getType().getArgumentsNumber();
                for (int arg = 0; arg < argumentsNumber; ++arg) {
                    String paramName = this.getUnusedName(paramMap, propertyName);
                    paramMap.put(paramName, (PsiType)(psiType == null ? objectClassType : psiType));
                }
            }
            if (addPageable) {
                String pageable = this.getUnusedName(paramMap, "pageable");
                PsiType pageablePsiType = this.getPageablePsiType();
                paramMap.put(pageable, (PsiType)(pageablePsiType == null ? objectClassType : pageablePsiType));
            }
            return paramMap;
        }

        @Nullable
        private PsiType getPageablePsiType() {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myPsiMethod.getProject());
            PsiClass pageableClass = psiFacade.findClass("org.springframework.data.domain.Pageable", this.myPsiMethod.getResolveScope());
            return pageableClass == null ? null : PsiTypesUtil.getClassType((PsiClass)pageableClass);
        }

        @NotNull
        private String getUnusedName(@NotNull Map<String, PsiType> paramMap, @NotNull String name) {
            if (paramMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramMap", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection$ReplaceAllParametersQuickFix", "getUnusedName"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection$ReplaceAllParametersQuickFix", "getUnusedName"));
            }
            String paramName = name;
            int i = 0;
            while (paramMap.containsKey(paramName)) {
                paramName = name + (++i + 1);
            }
            String string = paramName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/inspections/SpringDataJpaMethodInconsistencyInspection$ReplaceAllParametersQuickFix", "getUnusedName"));
            }
            return string;
        }
    }
}

