/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.data.model.repository.impl.SpringDataStereotypeComponent;
import com.intellij.spring.data.util.SpringDataUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesSearchUtil {
    public static List<CommonSpringBean> getAllRepositories(final @NotNull Module module, @NotNull Key<CachedValue<List<CommonSpringBean>>> cachedValueKey, final @NotNull String repositoryBaseClassName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (cachedValueKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedValueKey", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (repositoryBaseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryBaseClassName", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, cachedValueKey, (CachedValueProvider)new CachedValueProvider<List<CommonSpringBean>>(){

            public CachedValueProvider.Result<List<CommonSpringBean>> compute() {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                List<CommonSpringBean> resultElements = RepositoriesSearchUtil.getAllRepositories(scope, module.getProject(), repositoryBaseClassName);
                return CachedValueProvider.Result.create(resultElements, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
    }

    public static List<CommonSpringBean> getAllRepositories(@NotNull GlobalSearchScope scope, @NotNull Project project, @NotNull String repositoryBaseClassName) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        if (repositoryBaseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryBaseClassName", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getAllRepositories"));
        }
        PsiClass repositoryClass = JavaPsiFacade.getInstance((Project)project).findClass(repositoryBaseClassName, GlobalSearchScope.allScope((Project)project));
        return repositoryClass == null ? Collections.emptyList() : RepositoriesSearchUtil.getRepositoriesCustomBeans(scope, repositoryClass, project);
    }

    private static List<CommonSpringBean> getRepositoriesCustomBeans(@NotNull GlobalSearchScope scope, @NotNull PsiClass repositoryClass, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getRepositoriesCustomBeans"));
        }
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getRepositoriesCustomBeans"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getRepositoriesCustomBeans"));
        }
        ArrayList<CommonSpringBean> beans = new ArrayList<CommonSpringBean>();
        beans.addAll(RepositoriesSearchUtil.getRepositoryInterfaceInheritors(scope, repositoryClass));
        beans.addAll(RepositoriesSearchUtil.getAnnotatedRepositories(scope, project));
        return beans;
    }

    protected static List<? extends CommonSpringBean> getAnnotatedRepositories(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getAnnotatedRepositories"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/data/model/RepositoriesSearchUtil", "getAnnotatedRepositories"));
        }
        return SpringDataUtil.getRepositoryDefinitions(scope, project);
    }

    private static List<CommonSpringBean> getRepositoryInterfaceInheritors(GlobalSearchScope scope, PsiClass repositoryClass) {
        Collection allRepositories = ClassInheritorsSearch.search((ClassInheritorsSearch.SearchParameters)new ClassInheritorsSearch.SearchParameters(repositoryClass, (SearchScope)scope, true, false, false)).findAll();
        return ContainerUtil.map((Collection)allRepositories, (Function)new Function<PsiClass, CommonSpringBean>(){

            public CommonSpringBean fun(PsiClass psiClass) {
                return new SpringDataStereotypeComponent(psiClass);
            }
        });
    }
}

