/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies;

import com.android.tools.idea.gradle.dsl.dependencies.Dependency;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.dependencies.ModuleDependency;
import com.android.tools.idea.gradle.dsl.dependencies.external.ExternalDependency;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class Dependencies
extends GradleDslElement {
    @Nullable
    private PsiFile myPsiFile;
    @Nullable
    private GrClosableBlock myClosureBlock;
    @NotNull
    private final List<ExternalDependency> myExternal;
    @NotNull
    private final List<ModuleDependency> myToModules;
    @NotNull
    private final List<ExternalDependency> myExternalToRemove;
    @NotNull
    private final Multimap<String, ExternalDependencySpec> myNewExternal;

    public Dependencies(@NotNull GradleDslElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "<init>"));
        }
        super(parent, null, "dependencies");
        this.myExternal = Lists.newArrayList();
        this.myToModules = Lists.newArrayList();
        this.myExternalToRemove = Lists.newArrayList();
        this.myNewExternal = HashMultimap.create();
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "getChildren"));
        }
        return immutableList;
    }

    @Override
    protected void apply() {
        Dependencies.applyChanges(this.myExternal);
        Dependencies.applyChanges(this.myToModules);
        this.removeExternalDependencies();
        this.applyNewExternalDependencies();
        this.myExternalToRemove.clear();
        this.myNewExternal.clear();
    }

    private static void applyChanges(@NotNull List<? extends Dependency> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "applyChanges"));
        }
        for (Dependency dependency : dependencies) {
            dependency.applyChanges();
        }
    }

    private void removeExternalDependencies() {
        for (ExternalDependency dependency : this.myExternalToRemove) {
            dependency.removeFromParent();
        }
    }

    private void applyNewExternalDependencies() {
        for (Map.Entry entry : this.myNewExternal.entries()) {
            this.applyChanges((String)entry.getKey(), (ExternalDependencySpec)entry.getValue());
        }
    }

    private void applyChanges(@NotNull String configurationName, @NotNull ExternalDependencySpec dependency) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "applyChanges"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "applyChanges"));
        }
        assert (this.myPsiFile != null);
        String compactNotation = dependency.compactNotation();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)this.myPsiFile.getProject());
        if (this.myClosureBlock == null) {
            String text = "dependencies {\n" + configurationName + " '" + compactNotation + "'" + "\n}";
            GrExpression expression = factory.createExpressionFromText((CharSequence)text);
            PsiElement added = this.myPsiFile.add((PsiElement)expression);
            assert (added instanceof GrMethodCallExpression);
            this.parse((GrMethodCallExpression)added);
            CodeStyleManager.getInstance((Project)this.myPsiFile.getProject()).reformat((PsiElement)this.myClosureBlock);
            return;
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)(configurationName + " '" + compactNotation + "'"));
        GrStatement added = this.myClosureBlock.addStatementBefore(statement, null);
        assert (added instanceof GrApplicationStatement);
        List<Dependency> dependencies = Dependency.parse(this, (GrMethodCall)((GrApplicationStatement)added));
        this.add(dependencies);
        CodeStyleManager.getInstance((Project)this.myPsiFile.getProject()).reformat((PsiElement)added);
    }

    @NotNull
    public ImmutableList<ExternalDependency> external() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myExternal);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "external"));
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ModuleDependency> toModules() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myToModules);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "toModules"));
        }
        return immutableList;
    }

    public void add(@NotNull String configurationName, @NotNull ExternalDependencySpec dependency) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "add"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "add"));
        }
        this.myNewExternal.put((Object)configurationName, (Object)dependency);
        this.setModified(true);
    }

    public void remove(@NotNull ExternalDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "remove"));
        }
        boolean removed = this.myExternal.remove(dependency);
        if (!removed) {
            String msg = String.format("Dependency '%1$s' cannot be removed because it does not belong to this model", dependency.compactNotation());
            throw new IllegalArgumentException(msg);
        }
        this.myExternalToRemove.add(dependency);
        this.setModified(true);
    }

    public boolean parse(@NotNull GrMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "parse"));
        }
        this.myClosureBlock = PsiElements.findClosableBlock(methodCallExpression, "dependencies");
        if (this.myClosureBlock == null) {
            return false;
        }
        GrMethodCall[] methodCalls = (GrMethodCall[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myClosureBlock, GrMethodCall.class);
        if (methodCalls == null) {
            return false;
        }
        for (GrMethodCall methodCall : methodCalls) {
            List<Dependency> dependencies = Dependency.parse(this, methodCall);
            this.add(dependencies);
        }
        return true;
    }

    private void add(@NotNull List<Dependency> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "add"));
        }
        for (Dependency dependency : dependencies) {
            this.add(dependency);
        }
    }

    private void add(@Nullable Dependency dependency) {
        if (dependency instanceof ExternalDependency) {
            this.myExternal.add((ExternalDependency)dependency);
        } else if (dependency instanceof ModuleDependency) {
            this.myToModules.add((ModuleDependency)dependency);
        }
    }

    @Override
    protected void reset() {
        Dependencies.reset(this.myExternal);
        Dependencies.reset(this.myToModules);
        this.myExternalToRemove.clear();
        this.myNewExternal.clear();
    }

    private static void reset(@NotNull List<? extends Dependency> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dsl/dependencies/Dependencies", "reset"));
        }
        for (Dependency dependency : dependencies) {
            dependency.resetState();
        }
    }

    @Nullable
    public GrClosableBlock getClosureBlock() {
        return this.myClosureBlock;
    }

    public void setPsiFile(@Nullable PsiFile psiFile) {
        this.myPsiFile = psiFile;
    }
}

