/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies.external;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.Dependency;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.dependencies.external.CompactNotation;
import com.android.tools.idea.gradle.dsl.dependencies.external.MapNotation;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class ExternalDependency
extends Dependency {
    @NotNull
    protected final ExternalDependencySpec mySpec;
    @Nullable
    private String myNewVersion;

    protected ExternalDependency(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull String configurationName, @NotNull ExternalDependencySpec spec) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "<init>"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "<init>"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "<init>"));
        }
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "<init>"));
        }
        super(parent, methodCall, configurationName);
        this.mySpec = spec;
    }

    @Nullable
    public String group() {
        return this.mySpec.group;
    }

    @NotNull
    public String name() {
        String string = this.mySpec.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "name"));
        }
        return string;
    }

    @Nullable
    public String version() {
        return this.mySpec.version;
    }

    public void version(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "version"));
        }
        this.myNewVersion = version;
        this.setModified(true);
    }

    @Nullable
    public String classifier() {
        return this.mySpec.classifier;
    }

    @Nullable
    public String extension() {
        return this.mySpec.extension;
    }

    @NotNull
    public String compactNotation() {
        String string = this.mySpec.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "compactNotation"));
        }
        return string;
    }

    @NotNull
    public ExternalDependencySpec spec() {
        ExternalDependencySpec externalDependencySpec = this.mySpec;
        if (externalDependencySpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "spec"));
        }
        return externalDependencySpec;
    }

    @Override
    protected void apply() {
        this.applyVersionChange();
    }

    private void applyVersionChange() {
        if (this.myNewVersion == null) {
            return;
        }
        this.applyVersion(this.myNewVersion);
        this.reset();
    }

    protected abstract void applyVersion(@NotNull String var1);

    @Override
    protected void reset() {
        this.myNewVersion = null;
    }

    @NotNull
    public static List<Dependency> parse(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull GrReferenceExpression configurationName, @NotNull GroovyPsiElement[] arguments) {
        ExternalDependency dependency;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
        }
        if (arguments.length == 0) {
            List<Dependency> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
            }
            return list;
        }
        GroovyPsiElement first = arguments[0];
        if (first instanceof GrLiteral) {
            List<Dependency> list = ExternalDependency.parseCompactNotation(parent, methodCall, configurationName, arguments);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
            }
            return list;
        }
        if (first instanceof GrNamedArgument && (dependency = ExternalDependency.parseMapNotation(parent, methodCall, configurationName, arguments)) != null) {
            List<Dependency> list = Collections.singletonList(dependency);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
            }
            return list;
        }
        List<Dependency> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
        }
        return list;
    }

    @NotNull
    private static List<Dependency> parseCompactNotation(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull GrReferenceExpression configurationName, @NotNull GroovyPsiElement[] arguments) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseCompactNotation"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseCompactNotation"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseCompactNotation"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseCompactNotation"));
        }
        ArrayList dependencies = Lists.newArrayList();
        for (GroovyPsiElement argument : arguments) {
            if (!(argument instanceof GrLiteral)) continue;
            GrLiteral literal = (GrLiteral)argument;
            CompactNotation dependency = CompactNotation.parse(parent, methodCall, configurationName.getText(), literal);
            if (dependency == null) continue;
            dependencies.add(dependency);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseCompactNotation"));
        }
        return arrayList;
    }

    @Nullable
    private static ExternalDependency parseMapNotation(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull GrReferenceExpression configurationName, @NotNull GroovyPsiElement[] arguments) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseMapNotation"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseMapNotation"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseMapNotation"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parseMapNotation"));
        }
        ArrayList namedArguments = Lists.newArrayList();
        for (GroovyPsiElement argument : arguments) {
            if (!(argument instanceof GrNamedArgument)) continue;
            namedArguments.add((GrNamedArgument)argument);
        }
        if (namedArguments.isEmpty()) {
            return null;
        }
        GrNamedArgument[] namedArgumentArray = namedArguments.toArray(new GrNamedArgument[namedArguments.size()]);
        MapNotation dependency = MapNotation.parse(parent, methodCall, configurationName.getText(), namedArgumentArray, null);
        if (dependency != null) {
            return dependency;
        }
        return null;
    }

    @NotNull
    public static List<Dependency> parse(@NotNull Dependencies parent, @NotNull GrMethodCallExpression expression) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
        }
        GrReferenceExpression configurationName = ExternalDependency.findValidConfigurationNameExpression((GrMethodCall)expression);
        if (configurationName == null) {
            List<Dependency> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
            }
            return list;
        }
        GrArgumentList argumentList = expression.getArgumentList();
        ArrayList dependencies = Lists.newArrayList();
        for (GroovyPsiElement arg : argumentList.getAllArguments()) {
            MapNotation dependency;
            GrNamedArgument[] namedArgs;
            GrListOrMap listOrMap;
            if (!(arg instanceof GrListOrMap) || !(listOrMap = (GrListOrMap)arg).isMap() || (namedArgs = listOrMap.getNamedArguments()).length <= 0 || (dependency = MapNotation.parse(parent, (GrMethodCall)expression, configurationName.getText(), namedArgs, listOrMap)) == null) continue;
            dependencies.add(dependency);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "parse"));
        }
        return arrayList;
    }

    protected boolean removeArgumentIfMoreThanOne(@NotNull GroovyPsiElement toRemove) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "removeArgumentIfMoreThanOne"));
        }
        GrMethodCall methodCall = this.getMethodCall();
        GroovyPsiElement[] arguments = methodCall.getArgumentList().getAllArguments();
        if (arguments.length > 1) {
            ArrayList newArguments = Lists.newArrayList();
            for (GroovyPsiElement argument : arguments) {
                if (argument == toRemove) continue;
                newArguments.add(argument.getText());
            }
            if (!newArguments.isEmpty()) {
                String text = Joiner.on((char)',').join((Iterable)newArguments);
                if (toRemove instanceof GrListOrMap) {
                    text = '(' + text + ')';
                }
                Project project = toRemove.getProject();
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
                GrArgumentList newArgumentList = factory.createArgumentListFromText(text);
                methodCall.getArgumentList().replaceWithArgumentList(newArgumentList);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)methodCall);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.mySpec.toString();
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/dependencies/external/ExternalDependency", "getChildren"));
        }
        return immutableList;
    }
}

