/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.profiling.view.AnalysisContentsDelegate;
import com.android.tools.idea.profiling.view.AnalysisResultsManager;
import com.android.tools.idea.profiling.view.CaptureEditor;
import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturePanel
extends JPanel
implements DesignerEditorPanelFacade {
    @NotNull
    private Project myProject;
    @NotNull
    private CaptureEditor myEditor;
    @NotNull
    private AnalyzerTask[] myTasks;
    @NotNull
    private ThreeComponentsSplitter myThreeComponentsSplitter;
    @Nullable
    private InlineProgressIndicator myProgressIndicator;
    @Nullable
    private AnalysisContentsDelegate myResultsDelegate;
    @Nullable
    private Runnable myFinishedLoadingCallback;

    public CapturePanel(@NotNull Project project, @NotNull CaptureEditor editor, @NotNull AnalyzerTask[] tasks, boolean startAsLoading) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/profiling/view/CapturePanel", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/profiling/view/CapturePanel", "<init>"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/profiling/view/CapturePanel", "<init>"));
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myTasks = tasks;
        this.myThreeComponentsSplitter = new ThreeComponentsSplitter(false);
        this.myThreeComponentsSplitter.setHonorComponentsMinimumSize(true);
        Disposer.register((Disposable)editor, (Disposable)this.myThreeComponentsSplitter);
        if (startAsLoading) {
            TaskInfo taskInfo = new TaskInfo(){

                @NotNull
                public String getTitle() {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturePanel$1", "getTitle"));
                    }
                    return "";
                }

                public String getCancelText() {
                    return null;
                }

                public String getCancelTooltipText() {
                    return null;
                }

                public boolean isCancellable() {
                    return false;
                }

                public String getProcessId() {
                    return null;
                }
            };
            this.myProgressIndicator = new InlineProgressIndicator(true, taskInfo){

                protected void queueRunningUpdate(@NotNull Runnable update) {
                    if (update == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/android/tools/idea/profiling/view/CapturePanel$2", "queueRunningUpdate"));
                    }
                    ApplicationManager.getApplication().invokeLater(update);
                }
            };
            this.setLayout(new GridBagLayout());
            this.add(this.myProgressIndicator.getComponent());
        }
    }

    public void setEditorPanel(final @NotNull JComponent editorPanel, final @NotNull AnalysisContentsDelegate delegate) {
        if (editorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPanel", "com/android/tools/idea/profiling/view/CapturePanel", "setEditorPanel"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/android/tools/idea/profiling/view/CapturePanel", "setEditorPanel"));
        }
        assert (!this.isDoneLoading());
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                CapturePanel.this.removeAll();
                CapturePanel.this.myProgressIndicator = null;
                CapturePanel.this.myResultsDelegate = delegate;
                CapturePanel.this.setLayout(new BorderLayout());
                CapturePanel.this.myThreeComponentsSplitter.setInnerComponent(editorPanel);
                AnalysisResultsManager.getInstance(CapturePanel.this.myProject).bind(CapturePanel.this);
                CapturePanel.this.add((Component)CapturePanel.this.myThreeComponentsSplitter, "Center");
                if (CapturePanel.this.myFinishedLoadingCallback != null) {
                    CapturePanel.this.myFinishedLoadingCallback.run();
                    CapturePanel.this.myFinishedLoadingCallback = null;
                }
            }
        });
    }

    public ThreeComponentsSplitter getContentSplitter() {
        return this.myThreeComponentsSplitter;
    }

    @Nullable
    public InlineProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    public boolean isDoneLoading() {
        return this.myProgressIndicator == null;
    }

    @NotNull
    public AnalyzerTask[] getAnalyzerTasks() {
        if (this.myTasks == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturePanel", "getAnalyzerTasks"));
        }
        return this.myTasks;
    }

    @NotNull
    public AnalysisReport performAnalysis(Set<? extends AnalyzerTask> tasks, @NotNull Set<AnalysisReport.Listener> listeners) {
        if (listeners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listeners", "com/android/tools/idea/profiling/view/CapturePanel", "performAnalysis"));
        }
        AnalysisReport analysisReport = this.myEditor.performAnalysis(tasks, listeners);
        if (analysisReport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturePanel", "performAnalysis"));
        }
        return analysisReport;
    }

    @NotNull
    public AnalysisContentsDelegate getContentsDelegate() {
        assert (this.myResultsDelegate != null);
        AnalysisContentsDelegate analysisContentsDelegate = this.myResultsDelegate;
        if (analysisContentsDelegate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturePanel", "getContentsDelegate"));
        }
        return analysisContentsDelegate;
    }

    @NotNull
    public CaptureEditor getEditor() {
        CaptureEditor captureEditor = this.myEditor;
        if (captureEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profiling/view/CapturePanel", "getEditor"));
        }
        return captureEditor;
    }

    public void runWhenFinishedLoading(@NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/profiling/view/CapturePanel", "runWhenFinishedLoading"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFinishedLoadingCallback = callback;
        if (this.isDoneLoading()) {
            this.myFinishedLoadingCallback.run();
            this.myFinishedLoadingCallback = null;
        }
    }
}

