/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web;

import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.FrameStateManager;
import com.intellij.javaee.make.J2EECompilerManager;
import com.intellij.javaee.web.WebLogicalRoot;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.validation.JasperValidationTask;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.util.Function;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebProjectComponent
implements NamedComponent {
    public WebProjectComponent(final Project project, J2EECompilerManager j2EECompilerManager, CompilerManager compilerManager, FrameStateManager saveAndSyncHandler, LogicalRootsManager logicalRootsManager, ProjectWideFacetListenersRegistry facetListenersRegistry) {
        j2EECompilerManager.setValidator(compilerManager, saveAndSyncHandler);
        compilerManager.addAfterTask((CompileTask)new JasperValidationTask(project));
        logicalRootsManager.registerLogicalRootProvider(WebLogicalRoot.WEB_ROOT_TYPE, (NotNullFunction)new NotNullFunction<Module, List<WebLogicalRoot>>(){

            @NotNull
            public List<WebLogicalRoot> fun(Module module) {
                Collection webFacets = WebFacet.getInstances((Module)module);
                List list = ContainerUtil.concat((Iterable)webFacets, (Function)new Function<WebFacet, Collection<? extends WebLogicalRoot>>(){

                    public Collection<? extends WebLogicalRoot> fun(WebFacet webFacet) {
                        List list = webFacet.getWebRoots();
                        return ContainerUtil.mapNotNull((Collection)list, (Function)new NullableFunction<WebRoot, WebLogicalRoot>(){

                            public WebLogicalRoot fun(WebRoot s) {
                                VirtualFile file = s.getFile();
                                return file != null ? new WebLogicalRoot(s) : null;
                            }
                        });
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/WebProjectComponent$1", "fun"));
                }
                return list;
            }
        });
        facetListenersRegistry.registerListener(WebFacet.ID, (ProjectWideFacetListener)new ProjectWideFacetAdapter<WebFacet>(){

            public void facetAdded(WebFacet facet) {
                WebDirectoryUtil.getWebDirectoryUtil(project).clearWebDirectoryCaches();
                ((LogicalRootsManager.LogicalRootListener)project.getMessageBus().syncPublisher(LogicalRootsManager.LOGICAL_ROOTS)).logicalRootsChanged();
            }

            public void facetConfigurationChanged(WebFacet facet) {
                WebDirectoryUtil.getWebDirectoryUtil(project).clearWebDirectoryCaches();
            }

            public void facetRemoved(WebFacet facet) {
                WebDirectoryUtil.getWebDirectoryUtil(project).clearWebDirectoryCaches();
                ((LogicalRootsManager.LogicalRootListener)project.getMessageBus().syncPublisher(LogicalRootsManager.LOGICAL_ROOTS)).logicalRootsChanged();
            }
        });
        project.getMessageBus().connect().subscribe(ArtifactManager.TOPIC, (Object)new ArtifactListener(){

            public void artifactAdded(@NotNull Artifact artifact) {
                if (artifact == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/j2ee/web/WebProjectComponent$3", "artifactAdded"));
                }
                WebProjectComponent.onArtifactChanged(project, artifact);
            }

            public void artifactRemoved(@NotNull Artifact artifact) {
                if (artifact == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/j2ee/web/WebProjectComponent$3", "artifactRemoved"));
                }
                WebProjectComponent.onArtifactChanged(project, artifact);
            }

            public void artifactChanged(@NotNull Artifact artifact, @NotNull String oldName) {
                if (artifact == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/j2ee/web/WebProjectComponent$3", "artifactChanged"));
                }
                if (oldName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/j2ee/web/WebProjectComponent$3", "artifactChanged"));
                }
                WebProjectComponent.onArtifactChanged(project, artifact);
            }
        });
    }

    private static void onArtifactChanged(Project project, Artifact artifact) {
        if (WebArtifactUtil.getInstance().isWebApplication(artifact.getArtifactType())) {
            ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("WebProjectComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/WebProjectComponent", "getComponentName"));
        }
        return "WebProjectComponent";
    }
}

